<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode class
 *
 * @var $this Vckit_Shortcode_Workflow_Item
 */

$title                   =
$subtitle                =
$text                    =
$image                   =
$image_float             =
$image_on_right_class    = '';

$title_tag               = 'h3';
$subtitle_tag            = 'h5';
$image_alignment         = 'center';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

if ( 'yes' == $image_float ) {
  $image_on_right_class = 'reverse';
}

?>
<div class="vckit-workflow-item">
  <span class="line"></span>
  <div class="vckit-workflow-item-inner <?php echo esc_attr( $image_on_right_class ) ?>">
    <div class="vckit-workflow-image <?php echo esc_attr( $image_alignment ); ?>">
      <?php if ( ! empty( $image ) ) {
        echo wp_get_attachment_image( $image, 'full' );
      } ?>
    </div>
    <div class="vckit-workflow-text">
      <span class="circle"></span>
        <?php if ( ! empty( $title ) ) { ?>
        <<?php echo esc_attr( $title_tag )?> class="vckit-workflow-title"><?php echo esc_attr( $title ) ?></<?php echo esc_attr( $title_tag )?>>
        <?php } ?>
        <?php if ( ! empty( $subtitle ) ) { ?>
        <<?php echo esc_attr( $subtitle_tag )?> class="vckit-workflow-subtitle"><?php echo esc_attr( $subtitle ) ?></<?php echo esc_attr( $subtitle_tag )?>>
        <?php } ?>
        <?php if ( ! $content && ! empty( $text ) ) { ?>
          <p class="text"><?php echo esc_attr( $text ) ?></p>
        <?php } else { ?>
          <div class="text"><?php echo wpb_js_remove_wpautop( $content, true ); // @codingStandardsIgnoreLine ?></div>
        <?php } ?>
    </div>
  </div>
</div>
