<?php
if ( ! defined( 'ABSPATH' ) ) { exit;
}
/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $el_class
 * Shortcode class
 * @var $this Vckit_Shortcode_Typed_Effect
 */
$before =
$after =
$google_fonts =
$font_container =
$el_class =
$css =
$font_container_data =
$google_fonts_data = '';

extract( $this->getAttributes( $atts ) );

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

extract( $this->getStyles( $el_class, $css, $google_fonts_data, $font_container_data, $atts ) );

$settings = get_option( 'wpb_js_google_fonts_subsets' );
if ( is_array( $settings ) && ! empty( $settings ) ) {
  $subsets = '&subset=' . implode( ',', $settings );
} else {
  $subsets = '';
}

if ( isset( $google_fonts_data['values']['font_family'] ) ) {
  wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $google_fonts_data['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $google_fonts_data['values']['font_family'] . $subsets );
}

if ( ! empty( $styles ) ) {
  $style = 'style="' . esc_attr( implode( ';', $styles ) ) . '"';
} else {
  $style = '';
}

$content = (array) vc_param_group_parse_atts( $content );

$typing = array();
foreach ( $content as $text ) {
  if ( isset( $text['text_animated'] ) ) {
    $typing[] = $text['text_animated'];
  }
}

wp_enqueue_style( 'animate-css' );
?>
  <<?php echo esc_attr( $font_container_data['values']['tag'] )?> class="vckit-animated-typing-wrap <?php echo esc_attr( $css_class ) ?>" <?php echo $style; // @codingStandardsIgnoreLine  ?>>
  <span><?php echo esc_html( $before ); ?></span>
  <span class="vckit-animated-typing-text"
    style="color: <?php echo esc_attr( $animated_color ) ?>; background: <?php echo esc_attr( $background_color ) ?>">
    <span class="vckit-animated-typing vckit-animated-<?php echo esc_attr( $typing_animation ) ?>"
      data-typing="<?php echo esc_attr( json_encode( $typing ) ) ?>"
      data-type-speed="<?php echo esc_attr( $type_speed ) ?>"
      data-start-delay="<?php echo esc_attr( $start_delay ) ?>"
      data-back-speed="<?php echo esc_attr( $back_speed ) ?>"
      data-back-delay="<?php echo esc_attr( $back_delay ) ?>"
      data-loop="<?php echo esc_attr( 'yes' == $disable_loop ? 'false': 'true' ) ?>"
      data-show-cursor="<?php echo esc_attr( 'yes' == $hide_cursor ? 'false': 'true' ) ?>"
    >
    </span>
  </span>
  <span><?php echo esc_html( $after ); ?></span>
</<?php echo esc_attr( $font_container_data['values']['tag'] ) ?>>
