<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @package Visual Compoer KIT
 */

$image =
$title =
$enable_subtitle =
$subtitle =
$google_fonts =
$use_theme_fonts =
$google_fonts_data =
$enable_link =
$link_new_tab =
$url =
$title_color =
$subtitle_color =
$bg_color =
$el_class = '';

$subtitle_styles = array();

$atts   = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts ); // @codingStandardsIgnoreLine

$settings = get_option( 'wpb_js_google_fonts_subsets' );
if ( is_array( $settings ) && ! empty( $settings ) ) {
  $subsets = '&subset=' . implode( ',', $settings );
} else {
  $subsets = '';
}

if ( 'yes' !== $use_theme_fonts ) {
  $google_fonts_data = $this->getGoogleFonts( $google_fonts, 'google_fonts' );
}

if ( isset( $google_fonts_data['values']['font_family'] ) ) {
  wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $google_fonts_data['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $google_fonts_data['values']['font_family'] . $subsets );
}

if ( 'yes' !== $use_theme_fonts ) {
  $title_style = $this->getGoogleFontsStyle( $google_fonts_data );
}

if ( empty( $title_style ) ) {
  $title_style = array();
}

if ( ! empty( $title_size ) ) {
  $title_style[] = 'font-size: ' . $title_size . 'px';
}

if ( ! empty( $title_color ) ) {
  $title_style[] = 'color: ' . $title_color;
}

$title_style = esc_attr( implode( '; ', $title_style ) );

if ( 'yes' == $enable_subtitle ) {
  if ( ! empty( $sub_title_size ) ) {
    $subtitle_styles[] = 'font-size: ' . $sub_title_size . 'px';
  }

  if ( ! empty( $subtitle_color ) ) {
    $subtitle_styles[] = 'color: ' . $subtitle_color;
  }

  $subtitle_style = esc_attr( implode( '; ', $subtitle_styles ) );
}

$css_classes = array(
  'vckit-image-banner',
  $el_class,
);

if ( $this->isEnableLazyload() ) {
  $css_classes[] = 'vckit-lazyload';
  $data_image = 'data-src=' . $this->getImageSrc( $image );
} else {
  $data_image = 'src=' . $this->getImageSrc( $image );
}
?>
<div class="vckit-image-banner__wrapper <?php echo esc_attr( implode( ' ', $css_classes ) ); ?>">
  <?php
    if ( 'yes' == $enable_link ) {
      $link_attr = '';
      if ( 'yes' == $link_new_tab ) {
        $link_attr = ' target="_blank"';
      }
  ?>
    <a class="vckit-image-banner__link" href="<?php esc_url( $url ); ?>" <?php echo esc_attr( $link_attr ); //@codingStandardsIgnoreLine  ?>></a>
  <?php
    }
  ?>
  <img class="vckit-image-banner__image" <?php echo esc_attr( $data_image ); //@codingStandardsIgnoreLine ?> alt="<?php echo esc_attr( $title ); ?>"/>
  <div class="vckit-image-banner__text" style="background-color: <?php echo esc_attr( $bg_color ); ?>">
    <h3 class="vckit-image-banner__title" style="<?php echo esc_attr( $title_style ); //@codingStandardsIgnoreLine ?>"><?php echo esc_attr( $title ); ?></h3>
    <?php if ( 'yes' == $enable_subtitle ) { ?>
      <p class="vckit-image-banner__subtitle" style="<?php echo esc_attr( $subtitle_style ); //@codingStandardsIgnoreLine ?>"><?php echo esc_attr( $subtitle ); ?></p>
    <?php
      }
    ?>
  </div>
</div>
