<?php
if ( ! defined( 'ABSPATH' ) ) { exit;
}

/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $el_class
 * Shortcode class
 * @var $this Vckit_Shortcodes_Heading_Effect
 */

$el_class =
$whole_text =
$first_half_text =
$second_half_text =
$google_fonts =
$google_fonts_data =
$animation = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$settings = get_option( 'wpb_js_google_fonts_subsets' );

if ( is_array( $settings ) && ! empty( $settings ) ) {
  $subsets = '&subset=' . implode( ',', $settings );
} else {
  $subsets = '';
}

if ( 'yes' !== $use_theme_fonts ) {
  $google_fonts_data = $this->getGoogleFonts( $google_fonts, 'google_fonts' );
}

if ( isset( $google_fonts_data['values']['font_family'] ) ) {
  wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $google_fonts_data['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $google_fonts_data['values']['font_family'] . $subsets );
}

if ( 'yes' !== $use_theme_fonts ) {
  $google_styles = $this->getGoogleFontsStyle( $google_fonts_data );
}

if ( empty( $google_styles ) ) {
  $google_styles = array();
}

if ( $heading_size ) {
  $google_styles[] = "font-size: {$heading_size}";
}

if ( $heading_color ) {
  $google_styles[] = "color: {$heading_color}";
}

if ( ! empty( $google_styles ) ) {
  $style = 'style="' . esc_attr( implode( '; ', $google_styles ) ) . '"';
} else {
  $style = '';
}
?>
<div class="vckit-heading-effect grid__item">
  <?php
// @codingStandardsIgnoreStart
  switch ( $animation ) {
    case 'kukuri';
      echo '<a class="link link--kukuri"
              ' . $style . '
              href="#"
              data-letters="' . $whole_text . '">
              ' . $whole_text . '
            </a>';
      break;

    case 'takiri' :
      echo '<a class="link link--takiri" href="#" ' . $style . '>' . $whole_text . '</a>';
      break;

    case 'surinami' :
      echo '<a class="link link--surinami" href="#" ' . $style . '>
              <span data-letters-l="' . $first_half_text . '" data-letters-r="' . $second_half_text . '">' . $first_half_text . $second_half_text . '</span>
            </a>';
      break;

    case 'kumya' :
      echo '<a class="link link--kumya" href="#" ' . $style . '>
              <span data-letters="' . $whole_text . '">
                ' . $whole_text . '
              </span>
            </a>';
      break;

    case 'manko' :
      echo '<a class="link link--manko" href="#" ' . $style . '>
              ' . $whole_text . '
            </a>';
      break;

    case 'mallki' :
      echo '<a class="link link--mallki" ' . $style . ' href="#">
              ' . $whole_text . '
              <span data-letters="' . $whole_text . '"></span>
              <span data-letters="' . $whole_text . '"></span>
            </a>';
      break;

    case 'ilin' :
      echo '<a class="link link--ilin" href="#" ' . $style . '><span>' . $first_half_text . '</span><span>' . $second_half_text . '</span></a>';
      break;

    case 'urpi' :
      echo '<a class="link link--urpi" href="#" data-letters="' . $whole_text . '" ' . $style . '>' . $whole_text . '</a>';
      break;

    default:
      break;
  }
// @codingStandardsIgnoreEnd
  ?>
</div>

<?php if ( 'urpi' === $animation ) : ?>
<style>
  .vckit-heading-effect .link--urpi::before {
    -webkit-clip-path: url(#cp_up);
    clip-path: url(#cp_up);
  }

  .vckit-heading-effect .link--urpi::after {
    -webkit-clip-path: url(#cp_down);
    clip-path: url(#cp_down);
  }
</style>
<?php endif;
