<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}
/**
 * Shortcode attributes
 *
 * @package Visual Composer KIT
 *
 * @var $atts
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Grid_Samsung
 */

$grid_id =
$el_class =
$css =
$button_text =
$top_offset =
$preview_height =
$custom_class = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_classes = array(
  'vckit-grid-google',
  $custom_class,
);

$wrap_classes = array(
  'vckit-grid-wrap',
  $el_class,
  vc_shortcode_custom_css_class( $css ),
);

$this->addExcludedId( $this->postID() );
if ( 'custom' === $atts['post_type'] && ! empty( $atts['custom_query'] ) ) {
  $query = html_entity_decode( vc_value_from_safe( $atts['custom_query'] ), ENT_QUOTES, 'utf-8' );
  $post_data = query_posts( $query );
} else {
  $settings = $this->filterQuerySettings( $this->buildQuery( $atts ) );
  $post_data = query_posts( $settings );
}
?>
<?php if ( $post_data ) { ?>
  <div class="<?php echo esc_attr( implode( ' ', $wrap_classes ) ); ?>">
    <ul
      class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>"
      id="vckit-grid-google-<?php echo esc_attr( rand() ) ?>"
      data-button-text="<?php echo esc_attr( $button_text ) ?>"
      data-top-offset="<?php echo esc_attr( $top_offset ) ?>"
      data-preview-height="<?php echo esc_attr( $preview_height ) ?>"
    >
      <?php foreach ( $post_data as $item ) { ?><li>
          <a
            href="<?php echo esc_url( get_permalink( $item->ID ) ); ?>"
            data-largesrc="<?php echo esc_url( get_the_post_thumbnail_url( $item->ID, 'full' ) ) ?>"
            data-title="<?php echo get_the_title( $item->ID ) ?>"
            data-description="<?php // echo esc_attr( get_the_excerpt( $item->ID ) ) ?>"
          >
            <?php
              if ( has_post_thumbnail( $item->ID ) ) {
                echo get_the_post_thumbnail( $item->ID, 'thumbnail', array(
                  'class' => '',
                ) );
              } else {
                echo '<img src="http://placehold.it/150x150" alt="dummy">'; // @codingStandardsIgnoreLine
              }
            ?>
          </a>
        </li><?php } ?>
    </ul>
  </div>
<?php } ?>
