<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @package Visual Compoer KIT
 *
 * @var $atts
 * @var $style
 * @var $id
 * @var $el_class
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Button
 */

$style =
$id =
$el_class =
$custom_class = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_classes = array(
  'vckit-contact',
  'vckit-contact-' . $style,
  $custom_class,
  $el_class,
);
?>

<div class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>">
    <?php
    if ( isset( $id ) ) {
        $shortcode = do_shortcode( '[contact-form-7 id="' . $id . '"]' );

        $shortcode = preg_replace( '/<br(\s\/)?>/', '', $shortcode );

        if ( 'nao' == $style ) {
            $svg = '
<svg class="graphic" width="300%" height="100%" viewBox="0 0 1200 60" preserveAspectRatio="none">
  <path d="M0,56.5c0,0,298.666,0,399.333,0C448.336,56.5,513.994,46,597,46c77.327,0,135,10.5,200.999,10.5c95.996,0,402.001,0,402.001,0"></path>
  </svg>';
            $shortcode = preg_replace( '/(<label class="vckit-input__label".*>(\n|.)*?<\/label>)/', '${1}' . $svg,  $shortcode );
        }

        if ( 'shoko' == $style ) {
            $svg = '
<svg class="graphic" width="300%" height="100%" viewBox="0 0 1200 60" preserveAspectRatio="none">
  <path d="M0,56.5c0,0,298.666,0,399.333,0C448.336,56.5,513.994,46,597,46c77.327,0,135,10.5,200.999,10.5c95.996,0,402.001,0,402.001,0"></path>
  <path d="M0,2.5c0,0,298.666,0,399.333,0C448.336,2.5,513.994,13,597,13c77.327,0,135-10.5,200.999-10.5c95.996,0,402.001,0,402.001,0"></path>
</svg>';
            $shortcode = preg_replace( '/(<label class="vckit-input__label".*>(\n|.)*?<\/label>)/', '${1}' . $svg,  $shortcode );
        }

        if ( 'kozakura' == $style ) {
            $svg = '
<svg class="graphic" width="300%" height="100%" viewBox="0 0 1200 60" preserveAspectRatio="none">
  <path d="M1200,9c0,0-305.005,0-401.001,0C733,9,675.327,4.969,598,4.969C514.994,4.969,449.336,9,400.333,9C299.666,9,0,9,0,9v43c0,0,299.666,0,400.333,0c49.002,0,114.66,3.484,197.667,3.484c77.327,0,135-3.484,200.999-3.484C894.995,52,1200,52,1200,52V9z"></path>
</svg>';
            $shortcode = preg_replace( '/(<label class="vckit-input__label".*>(\n|.)*?<\/label>)/', '${1}' . $svg,  $shortcode );
        }

      echo $shortcode; // @codingStandardsIgnoreLine
    }
    ?>
</div>
