<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @package Visual Compoer KIT
 *
 * @var $atts
 * @var $style
 * @var $title
 * @var $link
 * @var $size
 * @var $border_size
 * @var $radius_size
 * @var $text_size
 * @var $align
 * @var $button_block
 * @var $add_icon
 * @var $el_class
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Button
 */

$style =
$title =
$link =
$size =
$border_size =
$radius_sie =
$text_size =
$align =
$button_block =
$add_icon =
$text_color =
$background_color =
$border_color =
$el_class =
$custom_class =
$icon_align =
$icon_type =
$icon_entypo =
$icon_fontawesome =
$icon_linecons =
$icon_pixelicons =
$icon_typicons =
$custom_onclick =
$custom_onclick_code =
$a_href =
$a_title =
$a_target =
$a_rel = '';

$styles = array();
$icon_wrapper = false;
$icon_html = false;
$attributes = array();

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

//parse link
$link = ( '||' === $link ) ? '' : $link;
$link = vc_build_link( $link );
$use_link = false;
if ( strlen( $link['url'] ) > 0 ) {
  $use_link = true;
  $a_href = $link['url'];
  $a_title = $link['title'];
  $a_target = $link['target'];
  $a_rel = $link['rel'];
}

$wrapper_classes = array(
  'vckit-btn-container',
  'vckit-btn-' . $align,
);

$button_classes = array(
  'vckit-btn',
  'button--' . $style,
  'button--size-' . $size,
  'button--text-' . $text_size,
  'button--border-' . $border_size,
  'button--round-' . $radius_size,
  $custom_class,
  $this->getExtraClass( $el_class ),
  vc_shortcode_custom_css_class( $css, ' ' ),
);

if ( preg_match( '/^[A-Z0-9_\s]+$/', $title ) ) {
  $button_classes[] = 'button--text-upper';
}

if ( '' === trim( $title ) ) {
  $button_classes[] = 'vc_btn3-o-empty';
  $button_html = '<span>&nbsp;</span>';
} elseif ( 'nina' === $style || 'nanuk' === $style ) {
  $button_html = preg_replace( '/(\w)/', '<span>${1}</span>', $title );
} else {
  $button_html = '<span>' . $title . '</span>';
}

if ( 'true' === $button_block && 'inline' !== $align ) {
  $button_classes[] = 'button--block';
}
if ( 'true' === $add_icon ) {
  $button_classes[] = 'button--icon-' . $icon_align;

  $icon_class = $this->getIconClass( $atts );

  if ( $icon_wrapper ) {
    $icon_html = '<i class="button__icon"><span class="vckit-btn-icon-inner ' . esc_attr( $icon_class ) . '"></span></i>';
  } else {
    $icon_html = '<i class="button__icon ' . esc_attr( $icon_class ) . '"></i>';
  }

  if ( 'left' === $icon_align ) {
    $button_html = $icon_html . ' ' . $button_html;
  } else {
    $button_html .= ' ' . $icon_html;
  }
}

if ( $styles ) {
  $attributes[] = 'style="' . implode( ' ', $styles ) . '"';
}

$class_to_filter = implode( ' ', array_filter( $wrapper_classes ) );
// FIXME May not work
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->shortcode, $atts );

if ( $button_classes ) {
  $button_classes = esc_attr( apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $button_classes ) ), $this->shortcode, $atts ) );
  $attributes[] = 'class="' . trim( $button_classes ) . '"';
}

if ( 'lightbox' == $custom_onclick ) {
  $attributes[] = 'data-lightbox="lightbox"';
  $attributes[] = 'href="#' . trim( $lightbox_id ) . '"';
} else if ( 'video' == $custom_onclick ) {
  $attributes[] = 'data-lightbox="video"';
  $attributes[] = 'href="' . esc_url( $video_url ) . '"';
} else if ( $use_link ) {
  $attributes[] = 'href="' . trim( $a_href ) . '"';
  $attributes[] = 'title="' . esc_attr( trim( $a_title ) ) . '"';
  if ( ! empty( $a_target ) ) {
    $attributes[] = 'target="' . esc_attr( trim( $a_target ) ) . '"';
  }
  if ( ! empty( $a_rel ) ) {
    $attributes[] = 'rel="' . esc_attr( trim( $a_rel ) ) . '"';
  }
}

if ( 'code' == $custom_onclick && $custom_onclick_code ) {
  $attributes[] = 'onclick="' . esc_attr( $custom_onclick_code ) . '"';
}

$attributes[] = 'data-text="' . $title . '"';

$attributes = implode( ' ', $attributes );

?>
<div class="<?php echo esc_attr( $css_class ) ?>"><?php if ( $use_link ) {
    echo '<a ' . $attributes . '>' . $button_html . '</a>'; // @codingStandardsIgnoreLine
} else {
  echo '<button ' . $attributes . '>' . $button_html . '</button>'; // @codingStandardsIgnoreLine
} ?></div>
