<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $el_class
 * @var $delay
 * @var $css_animation
 * @var $css
 *
 * @var $content - shortcode content
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Animated_Block
 */

$el_class =
$css_animation =
$css = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$el_class = $this->getExtraClass( $el_class );

$delay = (float) $delay;

$css_classes = array(
  'vckit-anim',
  $el_class,
  $this->getCSSAnimation( $css_animation ),
  vc_shortcode_custom_css_class( $css ),
);

$styles = array();
$styles[] = '-webkit-animation-delay: ' . $delay . 's';
$styles[] = 'animation-delay: ' . $delay . 's';

?>
<div class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>" style="<?php echo esc_attr( implode( '; ', $styles ) ) ?>">
<?php echo wpb_js_remove_wpautop( $content ); //@codingStandardsIgnoreLine ?>
</div>
