<?php

/**
 * Create submenu items.
 *
 * @link       themelego.com
 * @since      1.0.0
 *
 * @package    Vckit
 * @subpackage Vckit/includes
 */

/**
 * Create submenu items.
 *
 * Registers a new menu item under 'Tools' and uses the dependency passed into
 * the constructor in order to display the page corresponding to this menu item.
 *
 * @package    Vckit
 * @subpackage Vckit/includes
 * @author     ThemeLego <contact@themelego.com>
 */
class Vckit_Submenu {

  /**
   * A reference the class responsible for rendering the submenu page.
   *
   * @var    Vckit_Submenu
   * @access private
   */
  private $submenu_pages;

  /**
   * Initializes all of the partial classes.
   *
   * @param Vckit_Submenu_Pages $submenu_pages A reference to the class that renders the
   * page for the plugin.
   */
  public function __construct( $submenu_pages ) {
    $this->submenu_pages = $submenu_pages;
    $this->init();
  }

  /**
   * Creates the submenu item and calls on the Submenu Page object to render
   * the actual contents of the page.
   */
  public function add_submenu_pages() {
    $general_page = add_submenu_page(
      'vckit',
      'General settings',
      'General',
      'manage_options',
      'vckit',
      array( $this->submenu_pages, 'vckit_general' )
    );

    $module_page = add_submenu_page(
      'vckit',
      'Module settings',
      'Modules',
      'manage_options',
      'vckit-module',
      array( $this->submenu_pages, 'vckit_module' )
    );

    $smoothscroll_page = add_submenu_page(
      'vckit',
      'Smooth Scroll',
      'Smooth Scroll',
      'manage_options',
      'vckit-smoothscroll',
      array( $this->submenu_pages, 'vckit_smooth_scroll' )
    );

    add_submenu_page(
      'vckit',
      'About Vckit',
      'About',
      'manage_options',
      'vckit-about',
      array( $this->submenu_pages, 'vckit_about' )
    );

    // Include CMB CSS in the head to avoid FOUC.
    add_action( "admin_print_styles-{$general_page}", array( 'CMB2_hookup', 'enqueue_cmb_css' ) );
    add_action( "admin_print_styles-{$module_page}", array( 'CMB2_hookup', 'enqueue_cmb_css' ) );
    add_action( "admin_print_styles-{$smoothscroll_page}", array( 'CMB2_hookup', 'enqueue_cmb_css' ) );
  }

  /**
   * Adds a submenu for this plugin to the 'Lightbox' menu.
   */
  public function init() {
    add_action( 'admin_menu', array( $this, 'add_submenu_pages' ) );
  }
}
