<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Workflow class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Workflow extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_workflow';
  protected $name = 'Workflow';
  protected $desc = 'Workflow by Vckit';

  public function params() {
    return array(
      'icon'                    => vc_addons_kit_assets( 'img/icons/workflow.png' ),
      'as_parent'               => array(
        'only' => 'vckit_workflow_item',
      ),
      'content_element'         => true,
      'show_settings_on_create' => true,
      'js_view'                 => 'VcColumnView',
      'params'                  => array(
        array(
          'type'       => 'dropdown',
          'heading'    => esc_html__( 'Animate Workflow', 'legocreative' ),
          'param_name' => 'animate',
          'value'      => array(
            esc_html__( 'Yes', 'legocreative' ) => 'yes',
            esc_html__( 'No', 'legocreative' )  => 'no',
          ),
          'description' => esc_html__( 'Animate Workflow shortcode when it comes into viewport', 'legocreative' ),
          'save_always' => true,
        ),
        array(
          'type'        => 'colorpicker',
          'heading'     => esc_html__( 'Workflow line color', 'legocreative' ),
          'param_name'  => 'line_color',
          'description' => esc_html__( 'Pick a color for the workflow line.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'    => 'colorpicker',
          'heading'   => esc_html__( 'Circle border color', 'legocreative' ),
          'param_name'  => 'circle_border',
          'description' => esc_html__( 'Pick a color for the circle border color.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'    => 'colorpicker',
          'heading'   => esc_html__( 'Circle background color', 'legocreative' ),
          'param_name'  => 'circle_bg',
          'description' => esc_html__( 'Pick a color for the circle background color.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type' => 'vckit_id',
          'param_name' => 'id',
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
  class WPBakeryShortCode_Vckit_Workflow extends WPBakeryShortCodesContainer {
  }
}
