<?php
if ( ! defined( 'ABSPATH' ) ) { exit;
}
/**
 * Elegant Addons Shortcode Typed-effect class.
 *
 * @since 1.0
 * @package Elegant Addons for VC
 */
class Vckit_Shortcode_Typed_Effect extends Vckit_Shortcode_Google_Fonts {

  protected $shortcode = 'vckit_typing';
  protected $name = 'Animated Typing';
  protected $desc = 'Animated your text';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/animated-typing.png' ),
      'params'      => array(
        array(
          'type'        => 'param_group',
          'heading'     => __( 'Animated Text', 'legocreative' ),
          'param_name'  => 'content',
          'value'       => urlencode(json_encode(array(
            array(
              'feature' => __( 'Enter text', 'legocreative' ),
            ),
          ))),
          'params' => array(
            array(
              'type'        => 'textfield',
              'admin_label' => true,
              'heading'     => __( 'Content', 'legocreative' ),
              'param_name'  => 'text_animated',
              'description' => __( 'Enter the content that would be animated', 'legocreative' ),
            ),
          ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Before typing text', 'legocreative' ),
          'param_name'  => 'before',
          'description' => __( 'Enter the content before the animated text', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'After typing text', 'legocreative' ),
          'param_name'  => 'after',
          'description' => __( 'Enter the content after the animated text', 'legocreative' ),
        ),
        array(
          'type' => 'font_container',
          'param_name' => 'font_container',
          'value' => 'tag:h2|text_align:left',
          'settings' => array(
            'fields' => array(
              'tag' => 'h2', // default value h2
              'text_align',
              'font_size',
              'line_height',
              'color',
              'tag_description' => __( 'Select element tag.', 'legocreative' ),
              'text_align_description' => __( 'Select text alignment.', 'legocreative' ),
              'font_size_description' => __( 'Enter font size.', 'legocreative' ),
              'line_height_description' => __( 'Enter line height.', 'legocreative' ),
              'color_description' => __( 'Select heading color.', 'legocreative' ),
            ),
          ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Use theme default font family?', 'legocreative' ),
          'param_name' => 'use_theme_fonts',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Use font family from the theme.', 'legocreative' ),
        ),
        array(
          'type' => 'google_fonts',
          'param_name' => 'google_fonts',
          'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
          'settings' => array(
            'fields' => array(
              'font_family_description' => __( 'Select font family.', 'legocreative' ),
              'font_style_description' => __( 'Select font styling.', 'legocreative' ),
            ),
          ),
          'dependency' => array(
            'element' => 'use_theme_fonts',
            'value_not_equal_to' => 'yes',
          ),
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Typed background', 'legocreative' ),
          'param_name'       => 'background_color',
          'description'      => __( 'Choose the color of the animated text background', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Typed color', 'legocreative' ),
          'param_name'       => 'animated_color',
          'description'      => __( 'Choose the color of the text animated', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type' => 'animation_style',
          'heading' => __( 'Typing animation', 'legocreative' ),
          'param_name' => 'typing_animation',
          'settings' => array(
            'type' => array(
              'in',
              'other',
            ),
          ),
          'description' => __( 'Select "animation in" for typing.', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Disable loop', 'legocreative' ),
          'group' => __( 'Advanced Options', 'legocreative' ),
          'param_name' => 'disable_loop',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Disable loop around the typing.', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Type speed', 'legocreative' ),
          'group' => __( 'Advanced Options', 'legocreative' ),
          'param_name'  => 'type_speed',
          'value'       => '100',
          'description' => __( 'Speed of each character', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Start delay', 'legocreative' ),
          'group' => __( 'Advanced Options', 'legocreative' ),
          'param_name'  => 'start_delay',
          'value'       => '1000',
          'description' => __( 'Delay when start animation', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Back Speed', 'legocreative' ),
          'group' => __( 'Advanced Options', 'legocreative' ),
          'param_name'  => 'back_speed',
          'value'       => '0',
          'description' => __( 'Back speed', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Back Delay', 'legocreative' ),
          'group' => __( 'Advanced Options', 'legocreative' ),
          'param_name'  => 'back_delay',
          'value'       => '1000',
          'description' => __( 'Back delay', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Hide cursor', 'legocreative' ),
          'group' => __( 'Advanced Options', 'legocreative' ),
          'param_name' => 'hide_cursor',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Disable loop around the typing.', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Typing extends WPBakeryShortCode {}
}
