<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Sample class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Separator extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_separator';
  protected $name = 'Separator';
  protected $desc = 'Setting and customize your own Separator';

  public function params() {
    $icon_params = $this->vcIconElementParams();

    /* Separator (Divider)
    ---------------------------------------------------------- */
    $icons_params = vc_map_integrate_shortcode( $icon_params, 'i_', __( 'Icon', 'js_composer' ), array(
        'exclude' => array(
          'align',
          'css',
          'el_class',
          'link',
          'css_animation',
        ),
        // we need only type, icon_fontawesome, icon_blabla..., NOT color and etc
      ), array(
        'element' => 'layout',
        'value' => 'separator_with_text',
      ) );

    // populate integrated vc_icons params.
    if ( is_array( $icons_params ) && ! empty( $icons_params ) ) {
      foreach ( $icons_params as $key => $param ) {
        if ( is_array( $param ) && ! empty( $param ) ) {
          if ( isset( $param['admin_label'] ) ) {
            // remove admin label
            unset( $icons_params[ $key ]['admin_label'] );
          }
        }
      }
    }

    return array(
      'js_view' => 'VcTextSeparatorView',
      'class' => 'wpb_vc_separator',
      'icon' => vc_addons_kit_assets( 'img/icons/separator.png' ),
      'custom_markup' => '{{title}}',
      'params' => array_merge( array(
        array(
          'type' => 'dropdown',
          'param_name' => 'layout',
          'value' => array(
            __( 'Line separator', 'js_composer' ) => 'separator_no_text',
            __( 'Separator with Icon', 'js_composer' ) => 'separator_with_text',
          ),
        ),
      ), $icons_params, array(
        array(
          'type' => 'dropdown',
          'heading' => __( 'Icon position', 'js_composer' ),
          'param_name' => 'title_align',
          'value' => array(
            __( 'Center', 'js_composer' ) => 'separator_align_center',
            __( 'Left', 'js_composer' ) => 'separator_align_left',
            __( 'Right', 'js_composer' ) => 'separator_align_right',
          ),
          'description' => __( 'Select icon location.', 'js_composer' ),
          'dependency' => array(
            'element' => 'layout',
            'value' => 'separator_with_text',
          ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Separator alignment', 'js_composer' ),
          'param_name' => 'align',
          'value' => array(
            __( 'Center', 'js_composer' ) => 'align_center',
            __( 'Left', 'js_composer' ) => 'align_left',
            __( 'Right', 'js_composer' ) => 'align_right',
          ),
          'description' => __( 'Select separator alignment.', 'js_composer' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Color', 'js_composer' ),
          'param_name' => 'color',
          'value' => array_merge( getVcShared( 'colors' ), array( __( 'Custom color', 'js_composer' ) => 'custom' ) ),
          'std' => 'grey',
          'description' => __( 'Select color of separator.', 'js_composer' ),
          'param_holder_class' => 'vc_colored-dropdown',
        ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Custom Color', 'js_composer' ),
          'param_name' => 'accent_color',
          'description' => __( 'Custom separator color for your element.', 'js_composer' ),
          'dependency' => array(
            'element' => 'color',
            'value' => array( 'custom' ),
          ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Style', 'js_composer' ),
          'param_name' => 'style',
          'value' => getVcShared( 'separator styles' ),
          'description' => __( 'Separator display style.', 'js_composer' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Border width', 'js_composer' ),
          'param_name' => 'border_width',
          'value' => getVcShared( 'separator border widths' ),
          'description' => __( 'Select border width (pixels).', 'js_composer' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Element width', 'js_composer' ),
          'param_name' => 'el_width',
          'value' => array_merge( getVcShared( 'separator widths' ), array( __( 'Custom width', 'js_composer' ) => 'custom' ) ),
          'description' => __( 'Separator element width in percents.', 'js_composer' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Custom width', 'js_composer' ),
          'param_name' => 'accent_width',
          'description' => __( 'Custom separator width for your element.', 'js_composer' ),
          'dependency' => array(
            'element' => 'el_width',
            'value' => array( 'custom' ),
          ),
        ),
        //array(
          //'type' => 'dropdown',
          //'heading' => __( 'Animation', 'legocreative' ),
          //'param_name' => 'animation',
          //'description' => __( 'Select "animation in".', 'legocreative' ),
          //'value' => array(
            //__( 'Default', 'js_composer' ) => '',
            //__( 'FadeIn', 'js_composer' ) => 'fadein',
            //__( 'Scale', 'js_composer' ) => 'separator_align_right',
          //),
        //),
        array(
          'type' => 'textfield',
          'heading' => __( 'Extra class name', 'js_composer' ),
          'param_name' => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
        ),
        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS box', 'js_composer' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'js_composer' ),
        ),
      ) ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Separator extends WPBakeryShortCode {}
}
