<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * Elegant Addons Shortcode Progress Bar class.
 *
 * @since 1.0
 * @package Elegant Addons for VC
 */

class Vckit_Shortcode_Progress_Bar extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_progress_bar';
  protected $name = 'Progress Bar';
  protected $desc = 'Animated progress bar';

  public function params() {
    return array(
      'icon'        => vc_addons_kit_assets( 'img/icons/progress-bar.png' ),
      'params'      => array(

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Choose layout', 'legocreative' ),
          'param_name'  => 'layout',
          'std'         => 'vertical',
          'value'       => array(
            __( 'Vertical', 'legocreative' )    => 'vertical',
            __( 'Horizontal', 'legocreative' )  => 'horizontal',
          ),
          'save_always' => true,
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Choose style', 'legocreative' ),
          'param_name'  => 'style',
          'std'         => 'style01',
          'value'       => array(
            __( 'Default', 'legocreative' )             => 'style01',
            __( 'Value buble left', 'legocreative' )    => 'style02',
            __( 'Value buble center', 'legocreative' )  => 'style03',
            __( 'Value buble right', 'legocreative' )   => 'style04',
            __( 'Value inside', 'legocreative' )        => 'style05',
          ),
          'save_always' => true,
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Progress bar size', 'legocreative' ),
          'param_name'  => 'size',
          'description' => __( 'Enter the size of progress bar with px (3px, 5px,...)', 'legocreative' ),
          'value'       => '10px',
          'dependency'  => array(
            'element'             => 'style',
            'value_not_equal_to'  => 'style05',
          ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Progress bar shape', 'legocreative' ),
          'param_name'  => 'shape',
          'description' => __( 'Choose the shape to display progress bar. Circled shape shouldn\'t used with style Value buble left/right.', 'legocreative' ),
          'std'         => 'squared',
          'value'       => array(
            __( 'Squared', 'legocreative' ) => 'squared',
            __( 'Rounded', 'legocreative' ) => 'rounded',
            __( 'Circled', 'legocreative' ) => 'circled',
          ),
          'save_always' => true,
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Widget title', 'legocreative' ),
          'param_name'  => 'title',
          'description' => __( 'Enter text used as widget title (Note: located above content element).', 'legocreative' ),
        ),

        array(
          'type'        => 'param_group',
          'heading'     => __( 'Values', 'legocreative' ),
          'param_name'  => 'values',
          'description' => __( 'Enter values for graph - value, title and color.', 'legocreative' ),
          'value'       => urlencode( json_encode( array(
            array(
              'label' => __( 'Development', 'legocreative' ),
              'value' => '90',
            ),
            array(
              'label' => __( 'Design', 'legocreative' ),
              'value' => '80',
            ),
            array(
              'label' => __( 'Marketing', 'legocreative' ),
              'value' => '70',
            ),
          ) ) ),
          'params' => array(
            array(
              'type'        => 'textfield',
              'heading'     => __( 'Label', 'legocreative' ),
              'param_name'  => 'label',
              'description' => __( 'Enter text used as title of bar.', 'legocreative' ),
              'admin_label' => true,
            ),

            array(
              'type'        => 'textfield',
              'heading'     => __( 'Value', 'legocreative' ),
              'param_name'  => 'value',
              'description' => __( 'Enter value of bar.', 'legocreative' ),
              'admin_label' => true,
            ),

            array(
              'type'                => 'dropdown',
              'heading'             => __( 'Color', 'legocreative' ),
              'param_name'          => 'color',
              'value'               => array(
                  __( 'Default', 'legocreative' )            => '',
                ) + array(
                  __( 'Classic Grey', 'legocreative' )       => 'bar_grey',
                  __( 'Classic Blue', 'legocreative' )       => 'bar_blue',
                  __( 'Classic Turquoise', 'legocreative' )  => 'bar_turquoise',
                  __( 'Classic Green', 'legocreative' )      => 'bar_green',
                  __( 'Classic Orange', 'legocreative' )     => 'bar_orange',
                  __( 'Classic Red', 'legocreative' )        => 'bar_red',
                  __( 'Classic Black', 'legocreative' )      => 'bar_black',
                ) + getVcShared( 'colors-dashed' ) + array(
                  __( 'Custom Color', 'legocreative' )       => 'custom',
                ),
              'description'         => __( 'Select single bar background color.', 'legocreative' ),
              'admin_label'         => true,
              'param_holder_class'  => 'vc_colored-dropdown',
            ),

            array(
              'type'        => 'colorpicker',
              'heading'     => __( 'Custom color', 'legocreative' ),
              'param_name'  => 'customcolor',
              'description' => __( 'Select custom single bar background color.', 'legocreative' ),
              'dependency'  => array(
                'element' => 'color',
                'value'   => array( 'custom' ),
              ),
            ),

            array(
              'type'        => 'colorpicker',
              'heading'     => __( 'Custom text color', 'legocreative' ),
              'param_name'  => 'customtxtcolor',
              'description' => __( 'Select custom single bar text color.', 'legocreative' ),
              'dependency'  => array(
                'element' => 'color',
                'value'   => array( 'custom' ),
              ),
            ),
          ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Units', 'legocreative' ),
          'param_name'  => 'units',
          'description' => __( 'Enter measurement units (Example: %, px, points, etc. Note: graph value and units will be appended to graph title).', 'legocreative' ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Color', 'legocreative' ),
          'param_name'  => 'bgcolor',
          'value'       => array(
              __( 'Classic Grey', 'legocreative' )       => 'bar_grey',
              __( 'Classic Blue', 'legocreative' )       => 'bar_blue',
              __( 'Classic Turquoise', 'legocreative' )  => 'bar_turquoise',
              __( 'Classic Green', 'legocreative' )      => 'bar_green',
              __( 'Classic Orange', 'legocreative' )     => 'bar_orange',
              __( 'Classic Red', 'legocreative' )        => 'bar_red',
              __( 'Classic Black', 'legocreative' )      => 'bar_black',
            ) + getVcShared( 'colors-dashed' ) + array(
              __( 'Custom Color', 'legocreative' )       => 'custom',
            ),
          'description' => __( 'Select bar background color.', 'legocreative' ),
          'admin_label' => true,
          'param_holder_class' => 'vc_colored-dropdown',
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Bar custom background color', 'legocreative' ),
          'param_name'  => 'custombgcolor',
          'description' => __( 'Select custom background color for bars.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'bgcolor',
            'value'   => array( 'custom' ),
          ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Bar custom text color', 'legocreative' ),
          'param_name'  => 'customtxtcolor',
          'description' => __( 'Select custom text color for bars.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'bgcolor',
            'value'   => array( 'custom' ),
          ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Options', 'legocreative' ),
          'param_name'  => 'options',
          'value'       => array(
            __( 'Add stripes', 'legocreative' )                                          => 'striped',
            __( 'Add animation (Note: visible only with striped bar).', 'legocreative' ) => 'animated',
          ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),

        array(
          'type'        => 'css_editor',
          'heading'     => __( 'CSS box', 'legocreative' ),
          'param_name'  => 'css',
          'group'       => __( 'Design Options', 'legocreative' ),
        ),

      ),
    );
  }

  // @see js_composer/include/classes/shortcodes/vc-progress-bar.php
  public function convertAttributesToNewProgressBar( $atts ) {
    if ( isset( $atts['values'] ) && strlen( $atts['values'] ) > 0 ) {
      $values = vc_param_group_parse_atts( $atts['values'] );
      if ( ! is_array( $values ) ) {
        $temp = explode( ',', $atts['values'] );
        $paramValues = array();
        foreach ( $temp as $value ) {
          $data = explode( '|', $value );
          $colorIndex = 2;
          $newLine = array();
          $newLine['value'] = isset( $data[0] ) ? $data[0] : 0;
          $newLine['label'] = isset( $data[1] ) ? $data[1] : '';
          if ( isset( $data[1] ) && preg_match( '/^\d{1,3}\%$/', $data[1] ) ) {
            $colorIndex++;
            $newLine['value'] = (float) str_replace( '%', '', $data[1] );
            $newLine['label'] = isset( $data[2] ) ? $data[2] : '';
          }
          if ( isset( $data[ $colorIndex ] ) ) {
            $newLine['customcolor'] = $data[ $colorIndex ];
          }
          $paramValues[] = $newLine;
        }
        $atts['values'] = urlencode( json_encode( $paramValues ) );
      }
    }

    return $atts;
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Progress_Bar extends WPBakeryShortCode {}
}
