<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Mailchimp Newsletter class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Mailchimp extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_mailchimp';
  protected $name = 'Mailchimp Newsletter';
  protected $desc = 'Mailchimp subscribe form.';

  public function params() {
    $mcf = get_posts( 'post_type="mc4wp-form"&numberposts=-1' ); // @codingStandardsIgnoreLine

    $mailchimp_forms = array();
    if ( $mcf ) {
      foreach ( $mcf as $cform ) {
        $mailchimp_forms[ $cform->post_title ] = $cform->ID;
      }
    } else {
      $mailchimp_forms[ __( 'No mailchimp form found', 'legocreative' ) ] = 0;
    }

    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/mailchimp.png' ),
      'params' => array(
        array(
          'type' => 'dropdown',
          'heading' => __( 'Select newsletter form', 'legocreative' ),
          'param_name' => 'id',
          'value' => $mailchimp_forms,
          'save_always' => true,
          'description' => __( 'Choose previously created newsletter form from the drop down list.', 'legocreative' ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Newsletter style', 'legocreative' ),
          'param_name' => 'style',
          'value'      => array(
            __( 'Style 1', 'legocreative' )  => 'style1',
            __( 'Style 2', 'legocreative' )  => 'style2',
          ),
          'description' => __( 'Select style for your newsletter form.', 'legocreative' ),
        ),
        array(
          'type'       => 'textfield',
          'heading'    => __( 'Extra class name', 'legocreative' ),
          'param_name' => 'el_class',
          'description'       => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Mailchimp extends WPBakeryShortCode {}
}
