<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}


/**
 * VC KIT Shortcode Image Swap class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Image_Swap extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_image_swap';
  protected $name = 'Image Swap';
  protected $desc = 'Swap two images when hover';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/image-swap.png' ),
      'params'      => array(

        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Effect' ),
          'param_name' => 'effect',
          'value'      => array(
            __( 'Fade', 'legocreative' )  => 'fade',
            __( 'Slide Downward', 'legocreative' )    => 'slide-downward',
            __( 'Slide Upward', 'legocreative' )    => 'slide-upward',
            __( 'Slide Leftward', 'legocreative' )    => 'slide-leftward',
            __( 'Slide Rightward', 'legocreative' )    => 'slide-rightward',
            ),
          'std'        => 'fade',
          'description' => __( 'Select effect when swapping', 'legocreative' ),
        ),
        array(
          'type'       => 'attach_image',
          'heading'    => __( 'Before image', 'legocreative' ),
          'param_name' => 'beforeimage',
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'Select your image', 'legocreative' ),
        ),
        array(
          'type'       => 'attach_image',
          'heading'    => __( 'After image', 'legocreative' ),
          'param_name' => 'afterimage',
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'Select your image', 'legocreative' ),
        ),
        array(
          'type' => 'vc_link',
          'heading' => __( 'URL (Link)', 'legocreative' ),
          'param_name' => 'link',
          'description' => __( 'Add link.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Enable bottom shadow', 'legocreative' ),
          'param_name' => 'shadow',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'true',
          ),
          'std' => 'true',
          'description' => __( 'Enable bottom shadow when hover', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Hide first image when hover', 'legocreative' ),
          'param_name' => 'hide_before',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'true',
          ),
          'description' => __( 'Userful for transparent image', 'legocreative' ),
        ),
        array(
          'type'         => 'textfield',
          'heading'      => __( 'Extra class name', 'legocreative' ),
          'param_name'   => 'el_class',
          'description'  => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),
        array(
          'type'         => 'textfield',
          'heading'      => __( 'Link class name', 'legocreative' ),
          'param_name'   => 'link_class',
        ),

        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS box', 'legocreative' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ),
    );
  }

}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Image_Swap extends WPBakeryShortCode {}
}

