<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}


/**
 * VC KIT Shortcode Sample class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Image_Banner extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_image_banner';
  protected $name = 'Image Banner';
  protected $desc = 'Create a simple, creative banner';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/image-banner.png' ),
      'params'      => array(
        array(
          'type'       => 'attach_image',
          'heading'    => __( 'Image', 'legocreative' ),
          'param_name' => 'image',
          'description' => __( 'Select your image', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Title', 'legocreative' ),
          'param_name'        => 'title',
          'std' => 'Title',
          'description'       => __( 'Put your banner title here', 'legocreative' ),
        ),
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Enable subtitle', 'legocreative' ),
          'param_name'  => 'enable_subtitle',
          'value'       => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Enable this option show the subtitle', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Subtitle', 'legocreative' ),
          'param_name'        => 'subtitle',
          'std' => 'Subtitle',
          'description'       => __( 'Put your sub title here', 'legocreative' ),
          'dependency'  => array(
            'element' => 'enable_subtitle',
            'value'   => array( 'yes' ),
          ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Use theme default font family?', 'legocreative' ),
          'param_name' => 'use_theme_fonts',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'std' => 'yes',
          'description' => __( 'Use font family from the theme.', 'legocreative' ),
        ),
        array(
          'type' => 'google_fonts',
          'param_name' => 'google_fonts',
          'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
          'settings' => array(
            'fields' => array(
              'font_family_description' => __( 'Select font family for title.', 'legocreative' ),
              'font_style_description' => __( 'Select font styling for title.', 'legocreative' ),
            ),
          ),
          'dependency' => array(
            'element' => 'use_theme_fonts',
            'value_not_equal_to' => 'yes',
          ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Title font size', 'legocreative' ),
          'param_name'  => 'title_size',
          'std' => '12',
          'description' => __( 'Unit is pixel (px)', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Subtitle font size', 'legocreative' ),
          'param_name'  => 'sub_title_size',
          'std' => '12',
          'dependency'  => array(
            'element' => 'enable_subtitle',
            'value'   => array( 'yes' ),
          ),
          'description' => __( 'Unit is pixel (px)', 'legocreative' ),
        ),
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Enable Link', 'legocreative' ),
          'param_name'  => 'enable_link',
          'value'       => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Enable this option to add link to image', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Url', 'legocreative' ),
          'param_name'  => 'url',
          'value'       => '',
          'description' => __( 'Add url', 'legocreative' ),
          'dependency'  => array(
            'element' => 'enable_link',
            'value'   => array( 'yes' ),
          ),
        ),
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Open link in new tab', 'legocreative' ),
          'param_name'  => 'link_new_tab',
          'value'       => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Enable this option to open link in new tab', 'legocreative' ),
          'dependency'  => array(
            'element' => 'enable_link',
            'value'   => array(
              'yes',
            ),
          ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Title\'s color', 'legocreative' ),
          'param_name' => 'title_color',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Subtitle\'s color', 'legocreative' ),
          'param_name' => 'subtitle_color',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Background color', 'legocreative' ),
          'param_name' => 'bg_color',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'         => 'textfield',
          'heading'      => __( 'Extra class name', 'legocreative' ),
          'param_name'   => 'el_class',
          'description'  => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Image_Banner extends WPBakeryShortCode {}
}
