<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Interactive Grid class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Grid_Interactive extends Vckit_Shortcode_Grid {

  protected $grid = 'interactive';
  protected $name = 'Interactive Grid';
  protected $desc = 'Interactive hover effects grid.';

  public function params() {
    $atts = $this->getBasicAtts();

    foreach ( $atts as $key => $att ) {
      if ( 'post_type' == $att['param_name'] ) {
        $atts[$key]['value'][] = array( 'media', __( 'Media Library', 'legocreative' ) );
      }
    }

    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/interactive-grid.png' ),
      'params' => array_merge( array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Item uppear effect', 'legocreative' ),
          'param_name' => 'grid_effect',
          'value'      => array(
            __( 'Fade in', 'legocreative' )   => 'effect-1',
            __( 'Move up', 'legocreative' )   => 'effect-2',
            __( 'Scale up', 'legocreative' )   => 'effect-3',
            __( 'Fall Perspective', 'legocreative' )   => 'effect-4',
            __( 'Fly', 'legocreative' )   => 'effect-5',
            __( 'Flip', 'legocreative' )   => 'effect-6',
            __( 'Helix', 'legocreative' )   => 'effect-7',
            __( 'Popup', 'legocreative' )   => 'effect-8',
          ),
          'std'         => 'effect-1',
          'description' => __( 'Select animate grid loading effect.', 'legocreative' ),
        ),
      ), $atts, array(
        array(
          'type' => 'checkbox',
          'heading' => __( 'Show as a carousel', 'legocreative' ),
          'param_name' => 'enable_carousel',
          'value' => array( __( 'Yes', 'legocreative' ) => 'yes' ),
          'group' => __( 'Carousel Options', 'legocreative' ),
          'description' => __( 'Enable this option to show the grid as a carousel', 'legocreative' ),
        ),
      ), $this->addCarouselOptions( null, __( 'Carousel Options', 'legocreative' ) ), array(
        // Interactive tab
        array(
          'type' => 'dropdown',
          'heading' => __( 'Square ratio', 'legocreative' ),
          'param_name' => 'ratio',
          'value' => array(
            __( 'Original', 'legocreative' )   => 'original',
            __( '4:3', 'legocreative' )        => '43',
            __( '1:1 Square', 'legocreative' ) => '11',
            __( '16:9', 'legocreative' )       => '169',
            __( '3:2', 'legocreative' )        => '32',
            __( '2:1', 'legocreative' )        => '21',
            __( '3:4', 'legocreative' )        => '34',
          ),
          'std' => 'original',
          'group' => __( 'Interactive hover', 'legocreative' ),
          'description' => __( 'Select image size.', 'legocreative' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Effect', 'legocreative' ),
          'param_name' => 'effect',
          'value' => $this->getEffects(),
          'std' => 'lily',
          'group' => __( 'Interactive hover', 'legocreative' ),
          'description' => __( 'Select hover effect you want to display.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Override post effect?', 'legocreative' ),
          'param_name' => 'disable_item_effect',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'group' => __( 'Interactive hover', 'legocreative' ),
          'description' => __( 'If you choose this option, all item will has same effect. If not each item has effect define by its self', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Use theme default font family?', 'legocreative' ),
          'param_name' => 'disable_font',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'group' => __( 'Interactive hover', 'legocreative' ),
          'description' => __( 'Use font family from the theme.', 'legocreative' ),
        ),
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Open link in new tab', 'legocreative' ),
          'param_name'  => 'link_new_tab',
          'group' => __( 'Interactive hover', 'legocreative' ),
          'value'       => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Enable this option to open link in new tab', 'legocreative' ),
          'dependency'  => array(
            'element' => 'enable_link',
            'value'   => array( 'yes' ),
          ),
        ),

        array(
          'type' => 'textfield',
          'heading' => __( 'Image opacity', 'legocreative' ),
          'param_name' => 'image_opacity',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Interactive hover set opacity on Image to create the overlay. Choose image opacity', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Hover image opacity', 'legocreative' ),
          'param_name' => 'hover_image_opacity',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Choose hover image opacity', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Text Color', 'legocreative' ),
          'param_name' => 'color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for heading and paragraph.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Hover text color', 'legocreative' ),
          'param_name' => 'hover_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for when hover in.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Overlay color', 'legocreative' ),
          'param_name' => 'overlay_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Hover overlay color', 'legocreative' ),
          'param_name' => 'hover_overlay_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Heading font size', 'legocreative' ),
          'group'      => __( 'Customize', 'legocreative' ),
          'param_name' => 'heading_font_size',
          'description' => __( 'Choose heading font size', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Description font size', 'legocreative' ),
          'group'      => __( 'Customize', 'legocreative' ),
          'param_name' => 'description_font_size',
          'description' => __( 'Choose description font size', 'legocreative' ),
        ),
        array(
          'type'       => 'vckit_class',
          'heading'    => '',
          'param_name' => 'custom_class',
          'group'      => __( 'Customize', 'legocreative' ),
          'value'      => '',
        ),
      ) ),
    );
  }

  public function getSupportedPostTypes() {
    return apply_filters( 'vc_addons_kit_interactive_post_types', $this->getPostTypeList() );
  }

  public function registerScripts() {
    parent::registerScripts();

    $query_args = apply_filters( 'vc_addons_kit_interactive_fonts', array(
      'family' => 'Raleway:300,400,800',
      'subset' => 'latin,latin-ext',
    ) );
    wp_register_style( 'vckit_interactive_hover_fonts', add_query_arg( $query_args, '//fonts.googleapis.com/css' ), array(), null );
  }

  /**
   * Load plugin google fonts
   */
  public function loadFonts() {
    wp_enqueue_style( 'vckit_interactive_hover_fonts' );
  }

  public function getEffects( $reverse = false ) {
    $effects = apply_filters( 'vc_addons_kit_interactive_hover_effect', array(
      __( 'Lily', 'legocreative' )   => 'lily',
      __( 'Sadie', 'legocreative' )  => 'sadie',
      __( 'Honey', 'legocreative' )  => 'honey',
      __( 'Layla', 'legocreative' )  => 'layla',
      __( 'Zoe', 'legocreative' )    => 'zoe',
      __( 'Oscar', 'legocreative' )  => 'oscar',
      __( 'Marley', 'legocreative' ) => 'marley',
      __( 'Ruby', 'legocreative' )   => 'ruby',
      __( 'Roxy', 'legocreative' )   => 'roxy',
      __( 'Bubba', 'legocreative' )  => 'bubba',
      __( 'Romeo', 'legocreative' )  => 'romeo',
      __( 'Dexter', 'legocreative' ) => 'dexter',
      __( 'Sarah', 'legocreative' )  => 'sarah',
      __( 'Chico', 'legocreative' )  => 'chico',
      __( 'Milo', 'legocreative' )   => 'milo',

      // set2
      __( 'Julia', 'legocreative' )   => 'julia',
      __( 'Goliath', 'legocreative' ) => 'goliath',
      __( 'Hera', 'legocreative' )    => 'hera',
      __( 'Winston', 'legocreative' ) => 'winston',
      __( 'Selena', 'legocreative' )  => 'selena',
      __( 'Terry', 'legocreative' )   => 'terry',
      __( 'Phoebe', 'legocreative' )  => 'phoebe',
      __( 'Apollo', 'legocreative' )  => 'apollo',
      __( 'Kira', 'legocreative' )    => 'kira',
      __( 'Steve', 'legocreative' )   => 'steve',
      __( 'Moses', 'legocreative' )   => 'moses',
      __( 'Jazz', 'legocreative' )    => 'jazz',
      __( 'Ming', 'legocreative' )    => 'ming',
      __( 'Lexi', 'legocreative' )    => 'lexi',
      __( 'Duke', 'legocreative' )    => 'duke',
    ));

    if ( $reverse ) {
      $rev = array();

      foreach ( $effects as $key => $value ) {
        $rev[ $value ] = $key;
      }

      return $rev;
    }

    return $effects;
  }

  public function getCustomCSS( $atts ) {
    $color =
    $hover_color =
    $heading_font_size =
    $description_font_size =
    $image_opacity =
    $hover_image_opacity =
    $overlay_color =
    $hover_overlay_color =
    $custom_class = '';

    extract( $atts );

    $css = '';
    if ( $custom_class ) {
      $custom_class = '.vckit-grid.' . $custom_class . ' .effect-hover';

      // Fontsize
      if ( $heading_font_size ) {
        $css .= $custom_class . ' h2 { font-size: ' . $heading_font_size . '; }';
      }
      if ( $description_font_size ) {
        $css .= $custom_class . ' p { font-size: ' . $description_font_size . '; }';
      }

      // Color
      if ( $color ) {
        $css .= $custom_class . ' h2, ' . $custom_class . ' p { color: ' . $color . '; }';
      }
      if ( $hover_color ) {
        $css .= $custom_class . ':hover h2, ' . $custom_class . ':hover p { color: ' . $hover_color . '; }';
      }

      // Opacity
      if ( $image_opacity ) {
        $css .= $custom_class . ' img { opacity: ' . $image_opacity . '; }';
      }
      if ( $hover_image_opacity ) {
        $css .= $custom_class . ':hover img { opacity: ' . $hover_image_opacity . '; }';
      }

      // Overlay
      if ( $overlay_color ) {
        $css .= $custom_class . ' { background: ' . $overlay_color . '; }';
      }
      if ( $hover_overlay_color ) {
        $css .= $custom_class . ':hover { background: ' . $hover_overlay_color . '; }';
      }
    }

    return $css;
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Interactive_Grid extends WPBakeryShortCode {}
}
