<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Google Grid class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Grid_Google extends Vckit_Shortcode_Grid {

  protected $grid = 'google';
  protected $name = 'Google Grid';
  protected $desc = 'Thumbnail grid similar to Google Images.';
  protected $default_enabled = false;

  public function params() {
    $atts = $this->getBasicAtts();

    foreach ( $atts as $key => $att ) {
      if ( 'element_width' == $att['param_name'] || 'gap' == $att['param_name'] ) {
        unset( $atts[ $key ] );
      }
    }

    $atts[] = array(
      'type' => 'textfield',
      'heading' => __( 'Top offset', 'legocreative' ),
      'param_name' => 'top_offset',
      'value' => '0',
    );

    $atts[] = array(
      'type'       => 'colorpicker',
      'heading'    => __( 'Preview\'s background', 'legocreative' ),
      'param_name' => 'expand_bg',
      'description' => __( 'Select color for preview area.', 'legocreative' ),
      'edit_field_class' => 'vc_col-sm-4',
    );

    $atts[] = array(
      'type'       => 'colorpicker',
      'heading'    => __( 'Preview\'s text color', 'legocreative' ),
      'param_name' => 'expand_color',
      'description' => __( 'Select color for text.', 'legocreative' ),
      'edit_field_class' => 'vc_col-sm-4',
    );

    $atts[] = array(
      'type'       => 'colorpicker',
      'heading'    => __( 'Preview\'s button color', 'legocreative' ),
      'param_name' => 'button_color',
      'description' => __( 'Select color for button.', 'legocreative' ),
      'edit_field_class' => 'vc_col-sm-4',
    );

    $atts[] = array(
      'type' => 'textfield',
      'heading' => __( 'Preview height', 'legocreative' ),
      'param_name' => 'preview_height',
      'value' => '600',
    );

    $atts[] = array(
      'type' => 'textfield',
      'heading' => __( 'Expanded button text', 'legocreative' ),
      'param_name' => 'button_text',
      'value' => __( 'Read more', 'legocreative' ),
    );

    $atts[] = array(
      'type'       => 'vckit_class',
      'heading'    => '',
      'param_name' => 'custom_class',
      'value'      => '',
    );

    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/google-grid.png' ),
      'params' => $atts,
    );
  }

  public function getCustomCSS( $atts ) {
    $expand_bg =
    $expand_color =
    $button_color =
    $custom_class = '';

    extract( $atts );

    $css = '';
    if ( $custom_class ) {
      $custom_class = '.vckit-grid-google.' . $custom_class;

      if ( $expand_bg ) {
        $css .= $custom_class . ' .vckit-google-expander { background: ' . $expand_bg . '; }';
        $css .= $custom_class . ' li.vckit-google-expanded > a::after { border-bottom-color: ' . $expand_bg . '; }';
      }

      if ( $expand_color ) {
        $css .= $custom_class . ' .vckit-google-details h3, '
          . $custom_class . ' .vckit-google-details { color: ' . $expand_color . '; }';
      }
      if ( $button_color ) {
        $css .= $custom_class . ' .vckit-google-details a { color: ' . $button_color . '; border-color: ' . $button_color . '; }';
      }
    }

    return $css;
  }
}
