<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Animate Grid class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Grid_Animate extends Vckit_Shortcode_Grid {

  protected $grid = 'animate';
  protected $name = 'Elegant Grid';
  protected $desc = 'Loading Effects for Grid Items.';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/elegant-grid.png' ),
      'params' => array_merge( array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Effect', 'legocreative' ),
          'param_name' => 'effect',
          'value'      => array(
            __( 'Fade in', 'legocreative' )   => 'effect-1',
            __( 'Move up', 'legocreative' )   => 'effect-2',
            __( 'Scale up', 'legocreative' )   => 'effect-3',
            __( 'Fall Perspective', 'legocreative' )   => 'effect-4',
            __( 'Fly', 'legocreative' )   => 'effect-5',
            __( 'Flip', 'legocreative' )   => 'effect-6',
            __( 'Helix', 'legocreative' )   => 'effect-7',
            __( 'Popup', 'legocreative' )   => 'effect-8',
          ),
          'std'         => 'effect-1',
          'description' => __( 'Select animate grid loading effect.', 'legocreative' ),
        ),
      ), $this->getBasicAtts() ),
    );
  }
}
