<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; //Exit if accessed directly
}

class Vckit_Shortcode_Counter extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_counter';
  protected $name = 'Count Up';
  protected $desc = 'Make numbers eye-catching';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/count-up.png' ),
      'params'      => array(

        array(
          'type'              => 'textfield',
          'heading'           => __( 'End value', 'legocreative' ),
          'param_name'        => 'endnumber',
          'std'               => '1234',
          'description'       => __( 'Enter end value', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Start value from', 'legocreative' ),
          'param_name'        => 'startnumber',
          'std'               => '0',
          'description'       => __( 'Enter start value', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Caption', 'legocreative' ),
          'param_name'  => 'caption',
          'value'       => __( 'Caption' ),
          'description' => __( 'Enter caption of the Counter', 'legocreative' ),
        ),
        array(
          'type'              => 'checkbox',
          'heading'           => __( 'Add icon', 'legocreative' ),
          'param_name'        => 'addicon',
          'value'             => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
        ),
        array(
          'type'              => 'iconpicker',
          'heading'           => __( 'Icon', 'legocreative' ),
          'param_name'        => 'icon_fontawesome',
          'value'             => 'fa fa-image',
          'dependency'        => array(
            'element'         => 'addicon',
            'value'           => 'yes',
            ),
          'description'       => __( 'Select icon of the Counter', 'legocreative' ),
        ),
        array(
          'type'              => 'colorpicker',
          'heading'           => __( 'Color of icon', 'legocreative' ),
          'param_name'        => 'color-icon',
          'edit_field_class'  => 'vc_col-sm-4',
          'description'       => __( 'Select color of icon', 'legocreative' ),
        ),
        array(
          'type'              => 'colorpicker',
          'heading'           => __( 'Color of value', 'legocreative' ),
          'param_name'        => 'color-value',
          'edit_field_class'  => 'vc_col-sm-4',
          'description'       => __( 'Select color of value', 'legocreative' ),
        ),
        array(
          'type'              => 'colorpicker',
          'heading'           => __( 'Color of caption', 'legocreative' ),
          'param_name'        => 'color-caption',
          'edit_field_class'  => 'vc_col-sm-4',
          'description'       => __( 'Select color of caption', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Prefix', 'legocreative' ),
          'param_name'        => 'prefix',
          'std'               => '',
          'group'             => __( 'Advanced', 'legocreative' ),
          'description'       => __( 'example: $, @, #, etc', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Suffix', 'legocreative' ),
          'param_name'        => 'suffix',
          'std'               => '',
          'group'             => __( 'Advanced', 'legocreative' ),
          'description'       => __( 'example: +, %, K, etc', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Decimals' ),
          'param_name'  => 'decimals',
          'group'       => __( 'Advanced', 'legocreative' ),
          'std'         => '0',
          'description' => __( 'Number of digits after the decimal point', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Duration' ),
          'param_name'  => 'duration',
          'group'       => __( 'Advanced', 'legocreative' ),
          'std'         => '2.5',
          'description' => __( 'Duration of the Counter', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Decimal separator' ),
          'param_name'        => 'decimal-separator',
          'group'             => __( 'Advanced', 'legocreative' ),
          'std'               => '.',
          'edit_field_class'  => 'vc_col-sm-6',
          'description'       => __( 'Enter character as decimal separator', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Digit group separator' ),
          'param_name'        => 'digit-separator',
          'group'             => __( 'Advanced', 'legocreative' ),
          'std'               => '',
          'edit_field_class'  => 'vc_col-sm-6',
          'description'       => __( 'Enter character as digit group separator', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Size of icon' ),
          'param_name'        => 'size-icon',
          'group'             => __( 'Advanced', 'legocreative' ),
          'std'               => '40',
          'edit_field_class'  => 'vc_col-sm-4',
          'description'       => __( 'Enter size of icon in px', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Size of value' ),
          'param_name'        => 'size-value',
          'group'             => __( 'Advanced', 'legocreative' ),
          'std'               => '20',
          'edit_field_class'  => 'vc_col-sm-4',
          'description'       => __( 'Enter size of value in px', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Size of caption' ),
          'param_name'        => 'size-caption',
          'group'             => __( 'Advanced', 'legocreative' ),
          'std'               => '20',
          'edit_field_class'  => 'vc_col-sm-4',
          'description'       => __( 'Enter size of caption in px', 'legocreative' ),
        ),
        array(
          'type'         => 'textfield',
          'heading'      => __( 'Extra class name', 'legocreative' ),
          'param_name'   => 'el_class',
          'description'  => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),
      ),
    );
  }
}
