<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Sample class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Countdown extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_countdown';
  protected $name = 'Count Down';
  protected $desc = 'Beautiful count down element';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/count-down.png' ),
      'params'      => array(
        array(
          'type' => 'textfield',
          'heading' => __( 'Time format (YYYY-MM-DD HH:MM:SS)', 'legocreative' ),
          'param_name' => 'date',
          'description' => __( 'Example: "March 22nd, 2019 at 6:39pm", you will set "2019/03/22 18:39:00"', 'legocreative' ),
          'value' => '2019/03/22 18:39:00',
          ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Performance', 'legocreative' ),
          'param_name' => 'performance',
          'value' => array(
            __( 'Days', 'legocreative' ) => 'p1',
            __( 'Weeks - days', 'legocreative' ) => 'p2',
            __( 'Months - weeks - days', 'legocreative' ) => 'p3',
            __( 'Years - months - days', 'legocreative' ) => 'p4',
            __( 'Years - months - weeks - days', 'legocreative' ) => 'p5',
            ),
          'etd' => 'p1',
          'description' => __( 'Hours - minutes - seconds always exists at the end', 'legocreative' ),
          ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Style', 'legocreative' ),
          'param_name' => 'style',
          'value' => array(
            __( 'Style 1', 'legocreative' ) => 's1',
            __( 'Style 2', 'legocreative' ) => 's2',
            __( 'Style 3', 'legocreative' ) => 's3',
            __( 'Style 4', 'legocreative' ) => 's4',
            __( 'Style 5', 'legocreative' ) => 's5',
            __( 'Style 6', 'legocreative' ) => 's6',
            __( 'Style 7', 'legocreative' ) => 's7',
            __( 'Style 8', 'legocreative' ) => 's8',
            __( 'Style 9', 'legocreative' ) => 's9',
            ),
          'std' => 's1',
          'description' => __( 'Select and see what&#39ll happen', 'legocreative' ),
          ),
        array(
          'type'         => 'textfield',
          'heading'      => __( 'Extra class name', 'legocreative' ),
          'param_name'   => 'el_class',
          'description'  => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
          ),
        ),
      );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Veac_Countdown extends WPBakeryShortCode {}
}
