<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Interactive Item class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Card_Flip extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_card_flip';
  protected $name = 'Card Flip';
  protected $desc = 'The flip card';

  /**
   * Hooks
   *
   * @since  1.0
   * @return void
   */
  function hooks() {
    parent::hooks();
  }

  private function valueConverter( $list ) {
    $result = array();

    foreach ( $list as $name => $value ) {
      $result[ __( $name, 'legocreative' ) ] = $value; // @codingStandardsIgnoreLine
    }

    return $result;
  }

  public function params() {
    $front = __( 'Front', 'legocreative' );
    $back = __( 'Back', 'legocreative' );
    $style_2d = array(
      'element' => 'style',
      'value'   => array( '2d' ),
    );
    $style_3d = array(
      'element' => 'style',
      'value'   => array( '3d' ),
    );
    $shape_rounded = array(
      'element' => 'shape',
      'value'   => array( 'rounded' ),
    );
    $type_normal = array(
      'element' => 'type',
      'value'   => array( 'normal' ),
    );
    $front_bg_type_image = array(
      'element' => 'bg_type_front',
      'value'   => array( 'image' ),
    );
    $front_bg_type_color = array(
      'element' => 'bg_type_front',
      'value'   => array( 'color' ),
    );
    $front_bg_type_gradient = array(
      'element' => 'bg_type_front',
      'value'   => array( 'gradient' ),
    );
    $front_icon_bg_type_color = array(
      'element' => 'icon_bg_type',
      'value'   => array( 'color' ),
    );
    $front_icon_bg_type_gradient = array(
      'element' => 'icon_bg_type',
      'value'   => array( 'gradient' ),
    );
    $front_border_style_valid = array(
      'element' => 'border_style_front',
      'value'   => array( 'dotted', 'dashed', 'solid' ),
    );
    $front_border_style_one_color = array(
      'element' => 'border_color_front',
      'value'   => 'color',
    );
    $front_border_style_gradient = array(
      'element' => 'border_color_front',
      'value'   => 'gradient',
    );
    $front_feature_bg_type_color = array(
      'element' => 'ft_bg_type',
      'value'   => array( 'color' ),
    );
    $front_feature_bg_type_gradient = array(
      'element' => 'ft_bg_type',
      'value'   => array( 'gradient' ),
    );
    $front_feature_type_icon = array(
      'element' => 'ft_type',
      'value' => 'icon',
    );
    $front_feature_type_image = array(
      'element' => 'ft_type',
      'value' => 'image',
    );
    $back_bg_type_image = array(
      'element' => 'bg_type_back',
      'value'   => array( 'image' ),
    );
    $back_bg_type_color = array(
      'element' => 'bg_type_back',
      'value'   => array( 'color' ),
    );
    $back_bg_type_gradient = array(
      'element' => 'bg_type_back',
      'value'   => array( 'gradient' ),
    );
    $back_border_style_valid = array(
      'element' => 'border_style_back',
      'value'   => array( 'dotted', 'dashed', 'solid' ),
    );
    $back_border_style_one_color = array(
      'element' => 'border_color_back',
      'value'   => 'color',
    );
    $back_border_style_gradient = array(
      'element' => 'border_color_back',
      'value'   => 'gradient',
    );

    $style = array(
      'type'        => 'dropdown',
      'heading'     => 'Card Style',
      'param_name'  => 'style',
      'value'       => array(
        __( '2D', 'legocreative' ) => '2d',
        __( '3D', 'legocreative' ) => '3d',
      ),
    );
    $type = array(
      'type'        => 'dropdown',
      'heading'     => 'Card Type',
      'param_name'  => 'type',
      'value'       => array(
        __( 'Normal', 'legocreative' ) => 'normal',
        __( 'Mini', 'legocreative' ) => 'mini',
      ),
    );
    $shape = array(
      'type'        => 'dropdown',
      'heading'     => 'Card Shape',
      'param_name'  => 'shape',
      'value'       => array(
        __( 'Rectangle', 'legocreative' ) => 'rectangle',
        __( 'Rounded', 'legocreative' ) => 'rounded',
      ),
      'dependency'  => $style_2d,
    );
    $border_radius = array(
      'type'        => 'textfield',
      'heading'     => __( 'Card Border Radius', 'legocreative' ),
      'param_name'  => 'radius',
      'value'       => '10px',
      'dependency'  => $shape_rounded,
    );
    $smooth = array(
      'type'        => 'checkbox',
      'heading'     => __( 'Card Smooth', 'legocreative' ),
      'param_name'  => 'smooth',
      'value'       => array(
        __( 'Yes', 'legocreative' ) => 1,
      ),
      'dependency'  => $style_2d,
    );
    $direction_2d = array(
      'type'        => 'dropdown',
      'heading'     => 'Card Direction',
      'param_name'  => 'direction_2d',
      'value'       => array(
        __( 'Left To Right', 'legocreative' )  => 'toright',
        __( 'Right To Left', 'legocreative' )  => 'toleft',
        __( 'Top To Bottom', 'legocreative' )  => 'tobottom',
        __( 'Bottom To Top', 'legocreative' )  => 'totop',
      ),
      'dependency'  => $style_2d,
    );
    $direction_3d = array(
      'type'        => 'dropdown',
      'heading'     => 'Card Direction',
      'param_name'  => 'direction_3d',
      'value'       => array(
        __( 'Left To Right', 'legocreative' )  => 'toright',
        __( 'Right To Left', 'legocreative' )  => 'toleft',
      ),
      'dependency'  => $style_3d,
    );
    $el_class = array(
      'type'        => 'textfield',
      'heading'     => __( 'Extra class name', 'legocreative' ),
      'param_name'  => 'el_class',
      'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
    );
    $front_bg_type = array(
      'type'        => 'dropdown',
      'heading'     => 'Front Background',
      'param_name'  => 'bg_type_front',
      'value'       => array(
        __( 'Image', 'legocreative' )  => 'image',
        __( 'Color', 'legocreative' )  => 'color',
        __( 'Gradient', 'legocreative' )  => 'gradient',
      ),
      'group'       => $front,
    );
    $front_bg_url = array(
      'type'        => 'textfield',
      'heading'     => __( 'Front Background Url', 'legocreative' ),
      'param_name'  => 'bg_url_front',
      'value'       => '',
      'dependency'  => $front_bg_type_image,
      'group'       => $front,
    );
    $front_bg_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Front Background Color', 'legocreative' ),
      'param_name'  => 'bg_color_front',
      'dependency'  => $front_bg_type_color,
      'group'       => $front,
    );
    $front_bg_gradient_start = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Front Start Color', 'legocreative' ),
      'param_name'  => 'bg_gradient_start_front',
      'dependency'  => $front_bg_type_gradient,
      'group'       => $front,
    );
    $front_bg_gradient_end = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Front End Color', 'legocreative' ),
      'param_name'  => 'bg_gradient_end_front',
      'dependency'  => $front_bg_type_gradient,
      'group'       => $front,
    );
    $front_border_style = array(
      'type'        => 'dropdown',
      'heading'     => __( 'Front Border Style', 'legocreative' ),
      'param_name'  => 'border_style_front',
      'value' => array(
        __( 'None', 'legocreative' )   => 'none',
        __( 'Dotted', 'legocreative' ) => 'dotted',
        __( 'Dashed', 'legocreative' ) => 'dashed',
        __( 'Solid', 'legocreative' )  => 'solid',
      ),
      'group'       => $front,
    );
    $front_border_size = array(
      'type'        => 'textfield',
      'heading'     => __( 'Front Border size', 'legocreative' ),
      'param_name'  => 'border_size_front',
      'value'       => '2px',
      'dependency'  => $front_border_style_valid,
      'group'       => $front,
    );
    $front_border_color = array(
      'type'        => 'dropdown',
      'heading'     => __( 'Front Border color', 'legocreative' ),
      'param_name'  => 'border_color_front',
      'value'       => array(
        __( 'One color', 'legocreative' ) => 'color',
        __( 'Gradient color', 'legocreative' ) => 'gradient',
      ),
      'description' => 'Notice that dashed or dotted style border will not work with gradient color!',
      'dependency'  => $front_border_style_valid,
      'group'       => $front,
    );
    $front_border_one_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Choose front border color', 'legocreative' ),
      'param_name'  => 'border_one_color_front',
      'dependency'  => $front_border_style_one_color,
      'group' => $front,
    );
    $front_border_gradient_start = array(
      'type'       => 'colorpicker',
      'heading'    => __( 'Choose gradient start color', 'legocreative' ),
      'param_name' => 'border_gradient_start',
      'dependency' => $front_border_style_gradient,
      'edit_field_class' => 'vc_col-sm-6',
      'group'      => $front,
    );
    $front_border_gradient_end = array(
      'type'       => 'colorpicker',
      'heading'    => __( 'Choose gradient end color', 'legocreative' ),
      'param_name' => 'border_gradient_end',
      'dependency' => $front_border_style_gradient,
      'edit_field_class' => 'vc_col-sm-6',
      'group'      => $front,
    );
    $front_feature_bg_shape = array(
      'type'        => 'dropdown',
      'heading'     => __( 'Front Shape', 'legocreative' ),
      'param_name'  => 'ft_bg_shape',
      'value'       => array(
        __( 'Rectangle', 'legocreative' ) => 'rectangle',
        __( 'Rounded', 'legocreative' ) => 'rounded',
      ),
      'dependency'  => $style_2d,
    );
    $front_feature_bg_type = array(
      'type'        => 'dropdown',
      'heading'     => __( 'Front Feature Background Type', 'legocreative' ),
      'param_name'  => 'ft_bg_type',
      'value'       => array(
        __( 'None', 'legocreative' )  => 'none',
        __( 'Color', 'legocreative' )  => 'color',
        __( 'Gradient', 'legocreative' )  => 'gradient',
      ),
      'group'       => $front,
    );
    $front_feature_bg_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Front Feature Background Color', 'legocreative' ),
      'param_name'  => 'ft_bg_color',
      'dependency'  => $front_feature_bg_type_color,
      'group'       => $front,
    );
    $front_feature_bg_gradient_start = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Front Feature Start Color', 'legocreative' ),
      'param_name'  => 'ft_bg_gradient_start',
      'dependency'  => $front_feature_bg_type_gradient,
      'group'       => $front,
    );
    $front_feature_bg_gradient_end = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Front Feature End Color', 'legocreative' ),
      'param_name'  => 'ft_bg_gradient_end',
      'dependency'  => $front_feature_bg_type_gradient,
      'group'       => $front,
    );
    $front_feature_type = array(
      'type'    => 'dropdown',
      'heading' => __( 'Front Feature Type', 'legocreative' ),
      'value'   => array(
        __( 'Icon', 'legocreative' )  => 'icon',
        __( 'Image', 'legocreative' ) => 'image',
      ),
      'param_name'  => 'ft_type',
      'description' => __( 'Select Feature Icon or Image', 'legocreative' ),
      'group'       => $front,
    );
    $front_icon_type = array(
      'type'    => 'dropdown',
      'heading' => __( 'Icon library', 'legocreative' ),
      'value'   => array(
        __( 'Font Awesome', 'legocreative' ) => 'fontawesome',
        __( 'Open Iconic', 'legocreative' ) => 'openiconic',
        __( 'Typicons', 'legocreative' ) => 'typicons',
        __( 'Entypo', 'legocreative' ) => 'entypo',
        __( 'Linecons', 'legocreative' ) => 'linecons',
        __( 'Mono Social', 'legocreative' ) => 'monosocial',
      ),
      'param_name'  => 'icon_type',
      'dependency' => $front_feature_type_icon,
      'description' => __( 'Select icon library.', 'legocreative' ),
      'group'       => $front,
    );
    $front_icon_size = array(
      'type'        => 'textfield',
      'heading'     => __( 'Icon font size', 'legocreative' ),
      'param_name'  => 'icon_size',
      'value'       => '40px',
      'dependency'  => $front_feature_type_icon,
      'description' => __( 'Enter Icon Size', 'legocreative' ),
      'group'       => $front,
    );
    $front_icon_bg_type = array(
      'type' => 'dropdown',
      'heading' => __( 'Icon Color Type', 'legocreative' ),
      'param_name' => 'icon_bg_type',
      'value' => array(
        __( 'Color', 'legocreative' ) => 'color',
        __( 'Gradient', 'legocreative' ) => 'gradient',
      ),
      'dependency'  => $front_feature_type_icon,
      'group'       => $front,
    );
    $front_icon_bg_color = array(
      'type' => 'colorpicker',
      'heading' => __( 'Icon Color', 'legocreative' ),
      'param_name' => 'icon_bg_color',
      'dependency'  => $front_icon_bg_type_color,
      'group'       => $front,
    );
    $front_icon_bg_gradient_start = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Icon Gradient Start', 'legocreative' ),
      'param_name'  => 'icon_bg_gradient_start',
      'dependency'  => $front_icon_bg_type_gradient,
      'group'       => $front,
    );
    $front_icon_bg_gradient_end = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Icon Gradient End', 'legocreative' ),
      'param_name'  => 'icon_bg_gradient_end',
      'dependency'  => $front_icon_bg_type_gradient,
      'group'       => $front,
    );
    $front_image_url = array(
      'type'        => 'textfield',
      'heading'     => __( 'Front Feature URL', 'legocreative' ),
      'param_name'  => 'ft_url',
      'value'       => '',
      'dependency'  => $front_feature_type_image,
      'group'       => $front,
    );
    $front_feature_width = array(
      'type'        => 'textfield',
      'heading'     => __( 'Front Feature Width', 'legocreative' ),
      'param_name'  => 'ft_width',
      'value'       => '52px',
      'group'       => $front,
    );
    $front_feature_height = array(
      'type'        => 'textfield',
      'heading'     => __( 'Front Feature Height', 'legocreative' ),
      'param_name'  => 'ft_height',
      'value'       => '52px',
      'group'       => $front,

    );
    $front_title = array(
      'type'        => 'textfield',
      'heading'     => __( 'Front Title', 'legocreative' ),
      'param_name'  => 'title_front',
      'value'       => 'Lorem ipsum',
      'group'       => $front,
    );
    $front_title_size = array(
      'type'        => 'textfield',
      'heading'     => __( 'Front Title Font Size', 'legocreative' ),
      'param_name'  => 'title_size_front',
      'value'       => '18px',
      'group'       => $front,
    );
    $front_title_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Front Title Color', 'legocreative' ),
      'param_name'  => 'title_color_front',
      'group'       => $front,
    );
    $front_subtitle = array(
      'type'        => 'textfield',
      'heading'     => __( 'Front Subtitle', 'legocreative' ),
      'param_name'  => 'subtitle_front',
      'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip',
      'dependency'  => $type_normal,
      'group'       => $front,
    );
    $front_subtitle_size = array(
      'type'        => 'textfield',
      'heading'     => __( 'Front Subtitle Font Size', 'legocreative' ),
      'param_name'  => 'subtitle_size_front',
      'value'       => '15px',
      'dependency'  => $type_normal,
      'group'       => $front,
    );
    $front_subtitle_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Front Subtitle Color', 'legocreative' ),
      'param_name'  => 'subtitle_color_front',
      'dependency'  => $type_normal,
      'group'       => $front,
    );
    $back_bg_type = array(
      'type'        => 'dropdown',
      'heading'     => __( 'Back Background', 'legocreative' ),
      'param_name'  => 'bg_type_back',
      'value'       => array(
        __( 'Image', 'legoreative' )  => 'image',
        __( 'Color', 'legoreative' )  => 'color',
        __( 'Gradient', 'legoreative' )  => 'gradient',
      ),
      'group'       => $back,
    );
    $back_bg_url = array(
      'type'        => 'textfield',
      'heading'     => __( 'Back Background Url', 'legocreative' ),
      'param_name'  => 'bg_url_back',
      'value'       => '',
      'dependency'  => $back_bg_type_image,
      'group'       => $back,
    );
    $back_bg_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Back Background Color', 'legocreative' ),
      'param_name'  => 'bg_color_back',
      'dependency'  => $back_bg_type_color,
      'group'       => $back,
    );
    $back_bg_gradient_start = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Back Start Color', 'legocreative' ),
      'param_name'  => 'bg_gradient_start_back',
      'dependency'  => $back_bg_type_gradient,
      'group'       => $back,
    );
    $back_bg_gradient_end = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Back End Color', 'legocreative' ),
      'param_name'  => 'bg_gradient_end_back',
      'dependency'  => $back_bg_type_gradient,
      'group'       => $back,
    );
    $back_border_style = array(
      'type'        => 'dropdown',
      'heading'     => __( 'Back Border Style', 'legocreative' ),
      'param_name'  => 'border_style_back',
      'value' => array(
        __( 'None', 'legoreative' )   => 'none',
        __( 'Dotted', 'legoreative' ) => 'dotted',
        __( 'Dashed', 'legoreative' ) => 'dashed',
        __( 'Solid', 'legoreative' )  => 'solid',
      ),
      'group'       => $back,
    );
    $back_border_size = array(
      'type'        => 'textfield',
      'heading'     => __( 'Back Border size', 'legocreative' ),
      'param_name'  => 'border_size_back',
      'value'       => '2px',
      'dependency'  => $back_border_style_valid,
      'group'       => $back,
    );
    $back_border_color = array(
      'type'        => 'dropdown',
      'heading'     => __( 'Back Border color', 'legocreative' ),
      'param_name'  => 'border_color_back',
      'value'       => array(
        __( 'One color', 'legocreative' ) => 'color',
        __( 'Gradient color', 'legocreative' ) => 'gradient',
      ),
      'dependency'  => $back_border_style_valid,
      'description' => __( 'Notice that gradient color will not work on dashed and dotted border', 'legocreative' ),
      'group'       => $back,
    );
    $back_border_one_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Choose back border color', 'legocreative' ),
      'param_name'  => 'border_one_color_back',
      'dependency'  => $back_border_style_one_color,
      'group' => $back,
    );
    $back_border_gradient_start = array(
      'type'       => 'colorpicker',
      'heading'    => __( 'Choose gradient start color', 'legocreative' ),
      'param_name' => 'border_gradient_start_back',
      'dependency' => $back_border_style_gradient,
      'edit_field_class' => 'vc_col-sm-6',
      'group'      => $back,
    );
    $back_border_gradient_end = array(
      'type'       => 'colorpicker',
      'heading'    => __( 'Choose gradient end color', 'legocreative' ),
      'param_name' => 'border_gradient_end_back',
      'dependency' => $back_border_style_gradient,
      'edit_field_class' => 'vc_col-sm-6',
      'group'      => $back,
    );
    $back_title = array(
      'type'        => 'textfield',
      'heading'     => __( 'Back Title', 'legocreative' ),
      'param_name'  => 'title_back',
      'value'       => 'Lorem ipsum',
      'group'       => $back,
    );
    $back_title_size = array(
      'type'        => 'textfield',
      'heading'     => __( 'Back Title font size', 'legocreative' ),
      'param_name'  => 'title_size_back',
      'value'       => '18px',
      'group'       => $back,
    );
    $back_title_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Back Title Color', 'legocreative' ),
      'param_name'  => 'title_color_back',
      'group'       => $back,
    );
    $back_subtitle = array(
      'type'        => 'textfield',
      'heading'     => __( 'Back Subtitle', 'legocreative' ),
      'param_name'  => 'subtitle_back',
      'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip',
      'group'       => $back,
    );
    $back_subtitle_size = array(
      'type'        => 'textfield',
      'heading'     => __( 'Back Subtitle Font Size', 'legocreative' ),
      'param_name'  => 'subtitle_size_back',
      'value'       => '15px',
      'group'       => $back,
    );
    $back_subtitle_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Back Subtitle Color', 'legocreative' ),
      'param_name'  => 'subtitle_color_back',
      'group'       => $back,
    );
    $back_action_name = array(
      'type'        => 'textfield',
      'heading'     => __( 'Back Action Name', 'legocreative' ),
      'param_name'  => 'action_name',
      'value'       => 'Learn more',
      'dependency'  => $type_normal,
      'group'       => $back,
    );
    $back_action_url = array(
      'type'        => 'textfield',
      'heading'     => __( 'Back Action URL', 'legocreative' ),
      'param_name'  => 'action_url',
      'value'       => '',
      'dependency'  => $type_normal,
      'group'       => $back,
    );
    $back_action_bg_type = array(
      'type'        => 'dropdown',
      'heading'     => 'Back Action Type',
      'param_name'  => 'action_bg_type',
      'value'       => array(
        __( 'Color', 'legoreative' )  => 'color',
        __( 'Gradient', 'legoreative' )  => 'gradient',
      ),
      'dependency'  => $type_normal,
      'group'       => $back,
    );
    $back_action_bg_color = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Back Action Color', 'legocreative' ),
      'param_name'  => 'action_color',
      'dependency'  => $type_normal,
      'group'       => $back,
    );
    $back_action_bg_gradient_start = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Back Action Gradient Start', 'legocreative' ),
      'param_name'  => 'action_gradient_start',
      'dependency'  => $type_normal,
      'group'       => $back,
    );
    $back_action_bg_gradient_end = array(
      'type'        => 'colorpicker',
      'heading'     => __( 'Back Action Gradient End', 'legocreative' ),
      'param_name'  => 'action_gradient_end',
      'dependency'  => $type_normal,
      'group'       => $back,
    );

    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/card-flip.png' ),
      'params' => array_merge( array(
        $style,
        $type,
        $shape,
        $border_radius,
        $smooth,
        $direction_2d,
        $direction_3d,
        $el_class,
        $front_bg_type,
        $front_bg_url,
        $front_bg_color,
        $front_bg_gradient_start,
        $front_bg_gradient_end,
        $front_border_style,
        $front_border_size,
        $front_border_color,
        $front_border_one_color,
        $front_border_gradient_start,
        $front_border_gradient_end,
        $front_feature_bg_type,
        $front_feature_bg_color,
        $front_feature_bg_gradient_start,
        $front_feature_bg_gradient_end,
        $front_feature_type,
      ), $this->addIconLibrary( $front_feature_type_icon, $front ),
      array(
        $front_icon_size,
        $front_icon_bg_type,
        $front_icon_bg_color,
        $front_icon_bg_gradient_start,
        $front_icon_bg_gradient_end,
        $front_image_url,
        $front_feature_width,
        $front_feature_height,
        $front_title,
        $front_title_size,
        $front_title_color,
        $front_subtitle,
        $front_subtitle_size,
        $front_subtitle_color,
        $back_bg_type,
        $back_bg_url,
        $back_bg_color,
        $back_bg_gradient_start,
        $back_bg_gradient_end,
        $back_border_style,
        $back_border_size,
        $back_border_color,
        $back_border_one_color,
        $back_border_gradient_start,
        $back_border_gradient_end,
        $back_title,
        $back_title_size,
        $back_title_color,
        $back_subtitle,
        $back_subtitle_size,
        $back_subtitle_color,
        $back_action_name,
        $back_action_url,
        $back_action_bg_type,
        $back_action_bg_color,
        $back_action_bg_gradient_start,
        $back_action_bg_gradient_end,
        // ================End Back=======================
        array(
          'type'        => 'css_editor',
          'heading'     => __( 'CSS box', 'legocreative' ),
          'param_name'  => 'css',
          'group'       => __( 'Design Options', 'legocreative' ),
        ),
      ) ),
    );
  }
}
