<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_width
 * @var $full_height
 * @var $equal_height
 * @var $columns_placement
 * @var $content_placement
 * @var $parallax
 * @var $parallax_image
 * @var $css
 * @var $el_id
 * @var $video_bg
 * @var $video_bg_url
 * @var $video_bg_parallax
 * @var $parallax_speed_bg
 * @var $parallax_speed_video
 * @var $content - shortcode content
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row
 */
$el_class = $full_height = $parallax_speed_bg = $parallax_speed_video = $full_width = $equal_height = $flex_row = $columns_placement = $content_placement = $parallax = $parallax_image = $css = $el_id = $video_bg = $video_bg_url = $video_bg_parallax = '';
$disable_element = '';
$output = $after_output = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

wp_enqueue_script( 'wpb_composer_front_js' );

$el_class = $this->getExtraClass( $el_class );

$row_particle_id = 'vckit-particles-' . rand();

$css_classes = array(
  'vc_row',
  'wpb_row', //deprecated
  'vc_row-fluid',
  'vckit-row',
  $el_class,
  vc_shortcode_custom_css_class( $css ),
);

if ( 'yes' === $disable_element ) {
  if ( vc_is_page_editable() ) {
    $css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
  } else {
    return '';
  }
}

if ( vc_shortcode_custom_css_has_property( $css, array( 'border', 'background' ) ) || $video_bg || $parallax ) {
  $css_classes[] = 'vc_row-has-fill';
}

if ( ! empty( $atts['gap'] ) ) {
  $css_classes[] = 'vc_column-gap-' . $atts['gap'];
}

$wrapper_attributes = array();
// build attributes for wrapper
if ( empty( $el_id ) && ( 'tilt' == $row_bg_type || 'mouse' == $row_bg_type ) ) {
  $el_id = 'vkkit-row-' . rand();
}

if ( ! empty( $el_id ) ) {
  $wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
if ( ! empty( $full_width ) ) {
  $wrapper_attributes[] = 'data-vc-full-width="true"';
  $wrapper_attributes[] = 'data-vc-full-width-init="false"';
  if ( 'stretch_row_content' === $full_width ) {
    $wrapper_attributes[] = 'data-vc-stretch-content="true"';
  } elseif ( 'stretch_row_content_no_spaces' === $full_width ) {
    $wrapper_attributes[] = 'data-vc-stretch-content="true"';
    $css_classes[] = 'vc_row-no-padding';
  }
  $after_output .= '<div class="vc_row-full-width vc_clearfix"></div>';
}

if ( ! empty( $full_height ) ) {
  $css_classes[] = 'vc_row-o-full-height';
  if ( ! empty( $columns_placement ) ) {
    $flex_row = true;
    $css_classes[] = 'vc_row-o-columns-' . $columns_placement;
    if ( 'stretch' === $columns_placement ) {
      $css_classes[] = 'vc_row-o-equal-height';
    }
  }
}

if ( ! empty( $equal_height ) ) {
  $flex_row = true;
  $css_classes[] = 'vc_row-o-equal-height';
}

if ( ! empty( $content_placement ) ) {
  $flex_row = true;
  $css_classes[] = 'vc_row-o-content-' . $content_placement;
}

if ( ! empty( $flex_row ) ) {
  $css_classes[] = 'vc_row-flex';
}

$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

$parallax_speed = $parallax_speed_bg;
if ( $has_video_bg ) {
  $parallax = $video_bg_parallax;
  $parallax_speed = $parallax_speed_video;
  $parallax_image = $video_bg_url;
  $css_classes[] = 'vc_video-bg-container';
  wp_enqueue_script( 'vc_youtube_iframe_api_js' );
}

if ( ! empty( $parallax ) ) {
  wp_enqueue_script( 'vc_jquery_skrollr_js' );
  $wrapper_attributes[] = 'data-vc-parallax="' . esc_attr( $parallax_speed ) . '"'; // parallax speed
  $css_classes[] = 'vc_general vc_parallax vc_parallax-' . $parallax;
  if ( false !== strpos( $parallax, 'fade' ) ) {
    $css_classes[] = 'js-vc_parallax-o-fade';
    $wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
  } elseif ( false !== strpos( $parallax, 'fixed' ) ) {
    $css_classes[] = 'js-vc_parallax-o-fixed';
  }
}

if ( ! empty( $parallax_image ) ) {
  if ( $has_video_bg ) {
    $parallax_image_src = $parallax_image;
  } else {
    $parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );
    $parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );
    if ( ! empty( $parallax_image_src[0] ) ) {
      $parallax_image_src = $parallax_image_src[0];
    }
  }
  $wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr( $parallax_image_src ) . '"';
}
if ( ! $parallax && $has_video_bg ) {
  $wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
}
$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );

// ROW COLOR SCHEME
if ( $row_advanced_bgcolor ) {
  wp_enqueue_style( 'vckit-style' );
  $css_class .= ' vckit-row-color-' . $row_advanced_bgcolor;
}

if ( '' != $row_advanced_align ) {
  $css_class .= ' text-' . $row_advanced_align;
}

$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

if ( '' != $row_advanced_bgposition ) {
  $wrapper_attributes[] = 'style="background-position: ' . $row_advanced_bgposition . ' !important"';
}

// START CUSTOMIZE WITH ADVANED OPTIONS
// Map background
$row_advanced = '';

if ( 'none' != $row_bg_type ) {
  vc_addons_kit()->enqueueDefaultScripts();
}
if ( 'mouse' == $row_bg_type ) {
  $row_advanced .= '<div class="vckit-row-advance vckit-row-mouse-follow">';

  $row_bg_image_src = '';
  $image_info = wp_get_attachment_image_src( $row_bg_image, 'full' );
  if ( $image_info ) {
    $row_bg_image_src = $image_info[0];
  }

  $tilt_options = json_encode( array(
    'opacity' => 1,
    'bgfixed' => false,
    'extraImgs' => 1,
    'element' => array(
      'mouseMoveWatcher' => '#' . $el_id,
      'viewWatcher' => '#' . $el_id,
    ),
    'movement' => array(
      'perspective' => 1500,
      'translateX' => 15,
      'translateY' => 15,
      'translateZ' => 0,
      'rotateY' => 0,
    ),
  ) );

  $row_advanced .= '<img class="hero__img tilt-effect" data-tilt-options=\'' . $tilt_options . '\'  src="' . $row_bg_image_src . '" />';
  $row_advanced .= '</div>';
} elseif ( 'tilt' == $row_bg_type ) {
  $row_advanced .= '<div class="vckit-row-advance vckit-row-tilt-image">';

  $row_bg_image_src = '';
  $image_info = wp_get_attachment_image_src( $row_bg_image, 'full' );
  if ( $image_info ) {
    $row_bg_image_src = $image_info[0];
  }

  $tilt_options = json_encode( array(
    'opacity' => 0.6,
    'extraImgs' => 3,
    'element' => array(
      'mouseMoveWatcher' => '#' . $el_id,
      'viewWatcher' => '#' . $el_id,
    ),
    'movement' => array(
      'perspective' => 2000,
      'translateX' => 0,
      'translateY' => 0,
      'translateZ' => 20,
      'rotateX' => 3,
      'rotateY' => 10,
    ),
  ) );

  $row_advanced .= '<img class="hero__img tilt-effect" data-tilt-options=\'' . $tilt_options . '\'  src="' . $row_bg_image_src . '" />';
  $row_advanced .= '</div>';
} elseif ( 'google' == $row_bg_type ) {
  // Set map type to roadmap if custom style is used
  $map_style_output = urldecode( base64_decode( $rbm_style ) );

  wp_enqueue_script( 'vckit_google_map_js' );
  wp_enqueue_script( 'gmap3' );
  wp_enqueue_script( 'vckit-google-map-shortcode' );

  $row_advanced .=
    '<div class="vckit-row-bg-map vckit-map" data-coor="['
    . $rbm_coordinates . ']" data-zoom="'
    . $rbm_zoom . '" data-control-ui="false" data-scroll-wheel="false" data-map-type="'
    . $rbm_type . '" data-marker="" data-style="'
    . esc_attr( $map_style_output ) . '"></div>';
} elseif ( 'particles' == $row_bg_type ) {
  wp_enqueue_script( 'vckit-particlesjs' );
  $row_advanced .= '<div class="vckit-row-particles" id="' . $row_particle_id . '"></div>';
}

// Background overlay
$row_overlay_output = '';
if ( '' != $row_overlay_bg ) {
  $row_overlay_output = '<div class="vckit-row-overlay" style="background-color: ' . $row_overlay_bg . ';"></div>';
}

// END

$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
// start output
$output .= $row_advanced;
$output .= $row_overlay_output;
// end output
$output .= wpb_js_remove_wpautop( $content );
$output .= '</div>';
$output .= $after_output;

echo $output; //@codingStandardsIgnoreLine
?>
<?php if ( 'google' == $row_bg_type ) : ?>
  <script>
    jQuery( document ).ready( function ( $ ) {
      var mapCounter = 1;

      $('.vckit-row-bg-map').each(function(){
        $(this).attr('id','vckit-row-bg-map-'+ mapCounter);
        mapCounter++;
        var id = $(this).attr('id');

        function gmapInitialize( id ) {
          var map_canvas = document.getElementById( id),
            $el = $( map_canvas );
          var coor = $el.data('coor');
          var zooming = $el.data('zoom');
          var mapType = $el.data('map-type');
          var controlUI = $el.data('control-ui') ? false : true;
          var scrollWheel = $el.data('scroll-wheel');
          var marker = $el.data('marker');
          var style = $el.data('style');
          var myLatlng = new google.maps.LatLng( coor[0], coor[1] );
          var map_options = {
            center: myLatlng,
            zoom: zooming,
            disableDefaultUI: controlUI,
            scrollwheel: scrollWheel,
            styles: style
          }

          if ( ! style ) {
            map_options.mapTypeId = mapType;
          }

          var map = new google.maps.Map(map_canvas, map_options);

          if (marker != "") {
            var mapMarker = new google.maps.Marker({
              position: myLatlng,
              map: map,
              title: marker
            });
          }
        }

        gmapInitialize( id );
      });
    } );
  </script>
<?php elseif ( 'particles' == $row_bg_type ) : ?>
  <?php //@codingStandardsIgnoreStart ?>
  <script>
    jQuery(document).ready(function() {
      var json = '';
        <?php
          if ( isset( $particles_json ) && ! empty( $particles_json ) ) {
            $pson = $particles_json ? urldecode( base64_decode( $particles_json ) ) : '';
            $pson = json_encode(json_decode($pson));
        ?>
        json = `<?php echo $pson ?>`;
      <?php } else { ?>
        json = '{ "particles": { "number": { "value": 80, "density": { "enable": true, "value_area": 800 } }, "color": { "value": "#ffffff" }, "shape": { "type": "circle", "stroke": { "width": 0, "color": "#000000" }, "polygon": { "nb_sides": 5 }, "image": { "src": "img/github.svg", "width": 100, "height": 100 } }, "opacity": { "value": 0.5, "random": false, "anim": { "enable": false, "speed": 1, "opacity_min": 0.1, "sync": false } }, "size": { "value": 3, "random": true, "anim": { "enable": false, "speed": 40, "size_min": 0.1, "sync": false } }, "line_linked": { "enable": true, "distance": 150, "color": "#ffffff", "opacity": 0.4, "width": 1 }, "move": { "enable": true, "speed": 6, "direction": "none", "random": false, "straight": false, "out_mode": "out", "bounce": false, "attract": { "enable": false, "rotateX": 600, "rotateY": 1200 } } }, "interactivity": { "detect_on": "canvas", "events": { "onhover": { "enable": false, "mode": "repulse" }, "onclick": { "enable": false, "mode": "push" }, "resize": true }, "modes": { "grab": { "distance": 400, "line_linked": { "opacity": 1 } }, "bubble": { "distance": 400, "size": 40, "duration": 2, "opacity": 8, "speed": 3 }, "repulse": { "distance": 200, "duration": 0.4 }, "push": { "particles_nb": 4 }, "remove": { "particles_nb": 2 } } }, "retina_detect": false }';
      <?php } ?>

      setTimeout(function() {
        particlesJS('<?php echo $row_particle_id ?>', JSON.parse(json || '{}'));
      }, 3000);// Timeout for visual composer render row
    });
  </script>
  <?php //@codingStandardsIgnoreEnd ?>
<?php endif; ?>
