<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode class
 *
 * @var $this Vckit_Shortcode_Workflow
 */

$animate      = 'yes';
$line_color = $circle_border = $circle_bg = $id = $el_class = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
  'vckit-workflow',
  $el_class,
);

if ( 'yes' == $animate ) {
  $css_classes[] = 'vckit-workflow-animate';
}

?>

<div id="<?php echo esc_attr( $id ) ?>" class="<?php echo esc_attr( implode( $css_classes, ' ' ) ) ?>">
  <span class="main-line"></span>
  <?php echo wpb_js_remove_wpautop( $content ); //@codingStandardsIgnoreLine ?>
</div>
<?php //@codingStandardsIgnoreStart ?>
<style type="text/css">
  <?php if ( $line_color ) : ?>
  #<?php echo $id ?> .main-line,
  #<?php echo $id ?> .vckit-workflow-item .line {
    background-color: <?php echo $line_color ?>;
  }
  <?php endif ?>

  #<?php echo $id ?> .vckit-workflow-item .circle {
    <?php if ( $circle_border ) : ?>
    border-color: <?php echo $circle_border ?>;
    <?php endif ?>
    <?php if ( $circle_bg ) : ?>
    background-color: <?php echo $circle_bg ?>;
    <?php endif ?>
  }
</style>
<?php //@codingStandardsIgnoreEnd ?>
