<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}
/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $style
 * @var $show_icon
 * @var $plan_icon
 * @var $name
 * @var $sentense
 * @var $price
 * @var $currency
 * @var $period
 * @var $pricing_action
 * @var $pricing_link
 * @var $open_new_tab
 * @var $is_featured
 * @var $el_class
 *
 * @var $customize
 * @var $plan_color
 * @var $name_color
 * @var $sentence_color
 * @var $currency_color
 * @var $pricing_color
 * @var $period_color
 *
 * @var $css
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Pricing_Box
 */

$style =
$show_icon =
$plan_icon =
$name =
$sentense =
$price =
$curency =
$period =
$pricing_action =
$pricing_link =
$open_new_tab =
$is_featured =
$el_class =
$customize =
$plan_color =
$name_color =
$sentence_color =
$currency_color =
$pricing_color =
$period_color =
$css = '';
$custom_class = '';
$planIconClass = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
  'vckit-pricing-box',
  'pricing--' . $style,
  $is_featured ? 'pricing__item--featured' : '',
  $custom_class,
  $el_class,
  vc_shortcode_custom_css_class( $css ),
);

$features = (array) vc_param_group_parse_atts( $features );
$sentense_befores = array( 'yama', 'rabten', 'pema', 'karma', 'norbu', 'yonten', 'tashi' );
$price_befores = array( 'palden' );

?>
<div class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>" style="<?php if ( $plan_color ) echo 'color: ' . $plan_color //@codingStandardsIgnoreLine ?>">
  <div class="veac-pricing-header">
    <?php
      if ( 'rabten' == $style || 'yonten' == $style ) {
        if ( 'yes' === $show_icon ) {
          $iconData = array(
            'icon_type' => 'fontawesome',
            'icon_fontawesome' => $plan_icon,
          );
          $planIconClass = $this->getIconClass( $iconData );
      }
    ?>
        <div class="pricing__icon <?php echo esc_attr( $planIconClass ) ?>"></div>
    <?php } ?>

    <?php if ( 'palden' === $style ) : ?>
      <svg class="veac-pricing-header-img" version="1.1" id="Layer_1" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="300px" height="100px" viewBox="0 0 300 100" enable-background="new 0 0 300 100" xml:space="preserve">
        <path class="deco-layer deco-layer--1" opacity="0.6" fill="#FFFFFF" d="M30.913,43.944c0,0,42.911-34.464,87.51-14.191c77.31,35.14,113.304-1.952,146.638-4.729
c48.654-4.056,69.94,16.218,69.94,16.218v54.396H30.913V43.944z"></path>
        <path class="deco-layer deco-layer--2" opacity="0.6" fill="#FFFFFF" d="M-35.667,44.628c0,0,42.91-34.463,87.51-14.191c77.31,35.141,113.304-1.952,146.639-4.729
c48.653-4.055,69.939,16.218,69.939,16.218v54.396H-35.667V44.628z"></path>
        <path class="deco-layer deco-layer--3" opacity="0.7" fill="#FFFFFF" d="M43.415,98.342c0,0,48.283-68.927,109.133-68.927c65.886,0,97.983,67.914,97.983,67.914v3.716
H42.401L43.415,98.342z"></path>
        <path class="deco-layer deco-layer--4" fill="#FFFFFF" d="M-34.667,62.998c0,0,56-45.667,120.316-27.839C167.484,57.842,197,41.332,232.286,30.428
c53.07-16.399,104.047,36.903,104.047,36.903l1.333,36.667l-372-2.954L-34.667,62.998z"></path>
      </svg>
    <?php endif; ?>
    <?php if ( ! in_array( $style, $price_befores ) ) { ?>
      <h3 class="pricing__title" style="<?php if ( $name_color ) echo 'color: ' . $name_color //@codingStandardsIgnoreLine ?>"> <?php echo esc_html( $name ); ?> </h3>
    <?php } ?>

    <?php if ( in_array( $style, $sentense_befores ) ) { ?>
      <p class="pricing__sentence" style="<?php if ( $sentence_color ) echo 'color: ' . $sentence_color //@codingStandardsIgnoreLine ?>"> <?php echo esc_html( $sentense ); ?> </p>
    <?php } ?>

    <div class="pricing__price">
      <span class="pricing__anim pricing__anim--1" style="<?php if ( $pricing_color ) echo 'color: ' . $pricing_color //@codingStandardsIgnoreLine ?>">
        <span class="pricing__currency" style="<?php if ( $currency_color ) echo 'color: ' . $currency_color //@codingStandardsIgnoreLine ?>"><?php echo esc_html( $currency ); ?></span><?php echo esc_html( $price ); ?></span>
      <span class="pricing__anim pricing__anim--2">
        <span class="pricing__period" style="<?php if ( $period_color ) echo 'color: ' . $period_color //@codingStandardsIgnoreLine ?>">/ <?php echo esc_html( $period ); ?></span>
      </span>
    </div>

    <?php if ( in_array( $style, $price_befores ) ) { ?>
      <h3 class="pricing__title" style="<?php if ( $name_color ) echo 'color: ' . $name_color //@codingStandardsIgnoreLine ?>"> <?php echo esc_html( $name ); ?> </h3>
    <?php } ?>

    <?php if ( ! in_array( $style, $sentense_befores ) ) { ?>
      <p class="pricing__sentence" style="<?php if ( $sentence_color ) echo 'color: ' . $sentence_color //@codingStandardsIgnoreLine ?>"> <?php echo esc_html( $sentense ); ?> </p>
    <?php } ?>
  </div>

  <div class="veac-pricing-body">
    <ul class="pricing__feature-list">
      <?php foreach ( $features as $feature ) : ?>
        <li class="pricing__feature">
          <?php
            if ( isset( $feature['add_icon'] ) && 'yes' === $feature['add_icon'] ) {
              $feature['icon_type'] = 'fontawesome';
              $iconClass = $this->getIconClass( $feature );
          ?>
            <i class="<?php echo esc_attr( $iconClass ) ?>"></i>
          <?php } ?>
          <?php echo esc_html( $feature['feature'] ); ?>
        </li>
      <?php endforeach; ?>
    </ul>
  </div>

  <div class="veac-pricing-footer">
    <a class="pricing__action" href="<?php echo esc_url( $pricing_link ) ?>" <?php if ( 'yes' == $open_new_tab ) { echo 'target="_blank"'; } ?>>
      <?php if ( 'tashi' !== $style ) { ?>
        <?php echo esc_html( $pricing_action ) ?>
      <?php } else { ?>
        <?php vc_icon_element_fonts_enqueue( 'fontawesome' ); ?>
        <i class="fa fa-long-arrow-right"></i>
      <?php } ?>
  </a>
  </div>
</div>
