<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @package Visual Compoer KIT
 */

$layout =
$image =
$add_icon =
$icon_fontawesome =
$el_class =
$duration =
$type =
$delay =
$event =
$expandId =
$close_btn =
$effect = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts ); // @codingStandardsIgnoreLine

$css_classes = array(
  'vckit-interactive-notification',
  $el_class,
);

if ( 'growl' == $layout ) {
  $effect = $growl_effect;
} else if ( 'attached' == $layout ) {
  $effect = $attached_effect;
} else if ( 'bar' == $layout ) {
  $effect = $bar_effect;
} else {
  $effect = $other_effect;
}

$id = 'vckit-interactive-notification-' . rand();

if ( 'cornerexpand' == $effect || 'loadingcircle' == $effect ) {
  $expandId = 'vckit-notification-expand-' . rand();

  if ( 'cornerexpand' == $effect ) {
  ?>
  <div class="notification-shape shape-box" id="<?php echo esc_attr( $expandId ) ?>" data-path-to="m 0,0 500,0 0,500 -500,0 z">
    <svg xmlns="http://www.w3.org/2000/svg" width="100%" height="100%" viewBox="0 0 500 500" preserveAspectRatio="none">
      <path d="m 0,0 500,0 0,500 0,-500 z"/>
    </svg>
  </div>
  <?php } else if ( 'loadingcircle' == $effect ) { ?>
  <div class="notification-shape shape-progress" id="<?php echo esc_attr( $expandId ) ?>">
    <svg width="70px" height="70px"><path d="m35,2.5c17.955803,0 32.5,14.544199 32.5,32.5c0,17.955803 -14.544197,32.5 -32.5,32.5c-17.955803,0 -32.5,-14.544197 -32.5,-32.5c0,-17.955801 14.544197,-32.5 32.5,-32.5z"/></svg>
  </div>
  <?php } ?>
<?php } ?>

<div
  id="<?php echo esc_attr( $id ) ?>"
  class="<?php echo esc_attr( implode( ' ', $css_classes ) ) ?>"
  data-layout="<?php echo esc_attr( $layout ) ?>"
  data-effect="<?php echo esc_attr( $effect ) ?>"
  data-delay="<?php echo esc_attr( $delay ) ?>"
  data-duration="<?php echo esc_attr( $duration ) ?>"
  data-type="<?php echo esc_attr( $type ) ?>"
  data-event="<?php echo esc_attr( $event ) ?>"
  data-expand-id="<?php echo esc_attr( $expandId ) ?>"
  data-close-btn="<?php echo esc_attr( 'yes' == $close_btn ? 'true' : 'false' ) ?>">
    <?php
    if ( 'bar' == $layout ) {
      $iconData = array(
      'icon_type' => 'fontawesome',
      'icon_fontawesome' => $icon_fontawesome,
      );
      $iconClass = $this->getIconClass( $iconData );
    ?>
    <span class="icon <?php echo esc_attr( $iconClass ) ?>"></span>
    <?php
    } else if ( 'cornerexpand' == $effect ) {
      $cornerIcon = array(
        'icon_type' => 'fontawesome',
        'icon_fontawesome' => $icon_for_cornerexpand,
      );
      $cornerClass = $this->getIconClass( $cornerIcon );
    ?>
    <span class="icon <?php echo esc_attr( $cornerClass ) ?>"></span>
    <?php } else if ( 'thumbslider' == $effect ) { ?>
    <div class="ns-thumb"><img width="64" src="<?php echo esc_url( $this->getImageSrc( $image, 'thumbnail' ) ) ?>"/></div>
    <?php } ?>
  <div class="ns-content"><?php echo wpb_js_remove_wpautop( $content, true ); // @codingStandardsIgnoreLine ?></div>
</div>
