<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $navigators
 * @var $el_class
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Interactive_Navigation
 */

$style =
$navigators =
$speed =
$el_class = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
  'vckit-interactive-nav',
  'nav--' . $style,
  $el_class,
);

$navigators = (array) vc_param_group_parse_atts( $navigators );

$targets = array();
foreach ( $navigators as $item ) {
  if ( preg_match( '/^#\w+$/', $item['hash'] ) ) {
    $targets[] = $item['hash'];
  }
}

$id = 'vckit-navigator-' . rand();

?>

<nav class="<?php echo esc_attr( implode( ' ', $css_classes ) ) ?>"
  id="<?php echo esc_attr( $id ) ?>"
  data-target="<?php echo esc_attr( implode( ',', $targets ) ) ?>"
  data-speed="<?php echo esc_attr( $speed ) ?>">
  <ul>
    <?php foreach ( $navigators as $navigator ) : ?>
    <li>
      <a
        href="<?php echo esc_url( $navigator['hash'] ) ?>"
        class="nav__item" title="<?php echo esc_html( $navigator['title'] ) ?>">

        <?php if ( 'hagos' == $style ) { ?>
        <svg class="nav__icon" viewBox="0 0 48 24">
          <path d="M0.9,23c-0.2,0.2,0,0.8,0.2,0.9C1.2,24,1.3,24,1.4,24c0.2,0,0.3-0.1,0.5-0.1l10.7-4.1h30.7c2.2,0,3.9-1.8,3.9-3.9V3.9c0-2.2-1.8-3.9-3.9-3.9H5.9C3.7,0,2,1.8,2,3.9v11.8c0,2.2,1,3.5,3.2,3.5C5.1,19.2,2.2,21.5,0.9,23zM45.7,15.8c0,1.3-1.1,2.4-2.4,2.4h-31c-0.2,0-0.3,0.1-0.5,0.1l-9.4,4.3c0,0,4.1-2.9,4.7-3.7c0.1-0.2-0.1-0.4-0.2-0.5c-0.1-0.1-0.3-0.2-0.5-0.2H5.9c-1.3,0-2.4-1.1-2.4-2.4V3.9c0-1.3,1.1-2.4,2.4-2.4h37.4c1.3,0,2.4,1.1,2.4,2.4V15.8L45.7,15.8z"/>
        </svg>
        <?php } else if ( 'desta' == $style ) { ?>
        <svg class="nav__icon" viewBox="0 0 24 24">
          <path d="M4.5,19.8C4.5,19.8,4.5,19.8,4.5,19.8V4.2c0-0.3,0.2-0.5,0.4-0.7c0.2-0.1,0.5-0.1,0.8,0l13.5,7.8c0.2,0.1,0.4,0.4,0.4,0.7c0,0.3-0.2,0.5-0.4,0.7L5.7,20.4c-0.1,0.1-0.3,0.1-0.5,0.1C4.8,20.6,4.5,20.2,4.5,19.8z M6,5.6v12.8L17.2,12L6,5.6z"/>
        </svg>
        <?php } else if ( 'totit' == $style ) { ?>
        <svg class="nav__icon" viewBox="0 0 24 24">
          <path d="M17.6,2.9L17.6,2.9c-3.1-3.1-8.2-3.1-11.3,0l0,0C3.6,5.7,3.2,11,5.6,14.2l6.4,9.2l6.4-9.2C20.8,11,20.4,5.7,17.6,2.9z M12.1,11.1c-1.5,0-2.6-1.2-2.6-2.6s1.2-2.6,2.6-2.6s2.6,1.2,2.6,2.6S13.5,11.1,12.1,11.1z" />
        </svg>
        <?php } else if ( 'ayana' == $style ) { ?>
        <svg class="nav__icon" viewBox="0 0 16 16">
          <circle cx="8" cy="8" r="6.215"></circle>
        </svg>
        <?php } ?>

        <?php if ( 'etefu' == $style || 'kafa' == $style ) { ?>
        <span class="nav__item-inner"></span>
        <?php } ?>

        <span class="nav__item-title">
          <?php if ( 'beca' != $style || 'meklit' != $style ) { ?>
          <?php echo esc_html( $navigator['title'] ) ?>
          <?php } else { ?>
          <span><?php echo esc_html( $navigator['title'] ) ?></span>
          <?php } ?>
        </span>
      </a>
    </li>
    <?php endforeach; ?>
  </ul>
</nav>
