<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @package Visual Compoer KIT
 */

$ratio        = 'original';
$effect       = 'lily';
$image        = '';
$heading_thin = 'Interactive';
$heading_bold = 'Hover';

$description  =
$disable_font =
$enable_link  =
$link_new_tab =
$url          =
$el_class     =
$custom_class =
$css          = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts ); // @codingStandardsIgnoreLine

$fonts_class = '';
if ( 'yes' !== $disable_font ) {
  $this->loadFonts();
  $fonts_class = 'effect-fonts';
}

$css_classes = array(
  'effect-hover',
  $el_class,
  'effect-' . $effect,
  'ratio' . $ratio,
  $fonts_class,
  $custom_class,
  vc_shortcode_custom_css_class( $css ),
);

if ( $this->isEnableLazyload() ) {
  $css_classes[] = 'vckit-lazyload';
  $data_image = 'data-src="' . $this->getImageSrc( $image ) . '"';
} else {
  $data_image = 'src="' . $this->getImageSrc( $image ) . '"';
}

$link_attr = '';
if ( 'yes' == $enable_link ) {
  if ( 'yes' == $link_new_tab ) {
    $link_attr = ' target="_blank"';
  }
}
?>
<figure class="<?php echo esc_attr( implode( ' ', $css_classes ) ) ?>">
  <a href="<?php echo 'yes' == $enable_link ? esc_url( $url ) : 'javascript:;' ?>" <?php echo $link_attr //@codingStandardsIgnoreLine  ?>>
    <img <?php echo $data_image //@codingStandardsIgnoreLine ?> alt="<?php echo esc_attr( $heading_thin . ' ' . $heading_bold ) ?>"/>
    <figcaption>
      <div class="effect-caption">
        <h2><?php echo esc_html( $heading_thin ) ?> <span><?php echo esc_html( $heading_bold ) ?></span></h2>
        <p class="description">
          <?php echo $description . '&nbsp;' // @codingStandardsIgnoreLine ?>
        </p>
      </div>
    </figcaption>
  </a>
</figure>
