<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @package Visual Compoer KIT
 *
 * @var $atts
 * @var $type
 * @var $id
 * @var $display
 * @var $color_scheme
 * @var $number_items
 * @var $item_width_md
 * @var $item_width_sm
 * @var $item_width_xs
 * @var $spacing
 * @var $excerpt
 * @var $mode
 * @var $el_class
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Instagram_Feed
 */

$id =
$display =
$color_scheme =
$number_items =
$item_width_md =
$item_width_sm =
$item_width_xs =
$spacing =
$excerpt =
$mode =
$link_new_page =
$el_class = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts ); // @codingStandardsIgnoreLine

$el_class = $this->getExtraClass( $el_class );

$class = implode(
  ' ', array(
  'vc_col-md-' . $item_width_md,
  'vc_col-sm-' . $item_width_sm,
  'vc_col-xs-' . $item_width_xs,
  )
);

$css_classes = array(
  'veac-instagram-feed',
  'veac-instagram-color-' . $color_scheme,
  $el_class,
);

$excerpt = intval( $excerpt );

$id = preg_replace( '/[@#]/', '', $id );

if ( $this->isEnableLazyload() ) {
  $css_classes[] = 'vckit-lazyload';
}
?>

<div class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>">
<?php
if ( ! empty( $id ) ) {
  $media_array = $this->scrapeUser( $id, $number_items );

  if ( is_wp_error( $media_array ) ) { ?>
    <div class="veac-instagram-error"><p><?php echo esc_attr( $media_array->get_error_message() ); ?></p></div>
  <?php } else { ?>
    <div class="vc_row" <?php if ( 0 != $spacing ) {
      $margin = 15 + $spacing;
      echo 'style="margin-left:-' . $margin . 'px; margin-right:-' . $margin . 'px;"'; // @codingStandardsIgnoreLine

   } ?>>
      <?php foreach ( $media_array as $item ) { ?>
        <div
          class="<?php echo esc_attr( $class ); ?>"
          style="padding: <?php echo esc_attr( $spacing ); ?>px;">
          <div class="veac-grid-item veac-instagram-item <?php if ( 'video' == $item->getType() ) { echo ' video';
         } ?>">
            <a
              href="<?php echo esc_url( $item->getLink() ) ?>"
              target="<?php echo esc_attr( 'yes' == $link_new_page ? '_blank' : '_self' ); ?>">

              <figure>
                  <?php
                  if ( $this->isEnableLazyload() ) {
                    $data_image = 'data-src="' . $item->getImageThumbnailUrl() . '"';
                  } else {
                    $data_image = 'src="' . $item->getImageThumbnailUrl() . '"';
                  }
                  ?>
                <img <?php echo $data_image //@codingStandardsIgnoreLine ?> alt="Instagram caption" title="<?php $item->getCaption(); ?>" class="item-image" />

                <figcaption>
                  <ul class="veac-instagram-item-info">
                    <li class="likes">
                      <i class="fa fa-heart-o"></i>
                      <span><?php echo esc_attr( $item->getLikesCount() ); ?></span>
                  </li>
                    <li class="comments">
                      <i class="fa fa-comment-o"></i>
                      <span><?php echo esc_attr( $item->getCommentsCount() ); ?></span>
                    </li>
                  </ul>

                  <?php if ( $excerpt ) { ?>
                  <div class="veac-instagram-item-caption"> <?php echo trim( vc_addons_kit_substr( $item->getCaption(), $excerpt ) ); //@codingStandardsIgnoreLine ?> </div>
                  <?php } ?>
                </figcaption>
              </figure>

              <?php if ( 'GraphVideo' == $item->getType() ) { ?>
                <span class="play-button"><i class="fa fa-2x fa-play"></i></span>
              <?php } ?>
            </a>
          </div>
        </div>
      <?php } // End foreach(). ?>
    </div>
  <?php } // End if(). ?>
<?php } // End if(). ?>
</div>
