<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}
/**
 * Shortcode attributes
 *
 * @package Visual Compoer KIT
 *
 * @var $atts
 * @var $get
 * @var $user_id
 * @var $display
 * @var $color_scheme
 * @var $limit
 * @var $el_class
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Instafeed
 */

$token =
$sortby =

$display =
$color_scheme =
$limit =
$spacing =
$link_new_page =
$el_class =
'';

$atts   = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts ); // @codingStandardsIgnoreLine

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
  'vckit-instafeed',
  'vckit-instafeed--' . $color_scheme,
  $el_class,
);

if ( $this->isEnableLazyload() ) {
  $css_classes[] = 'vckit-lazyload';
}

$id = 'vckit-instafeed-' . rand();
?>
<div
  id="<?php echo esc_attr( $id ) ?>"
  class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>"
  data-token="<?php echo esc_attr( $token ) ?>"
  data-limit="<?php echo esc_attr( $limit ) ?>"
  data-sortby="<?php echo esc_attr( $sortby ) ?>"
  <?php echo $this->getCarouselAtts( $atts ) //@codingStandardsIgnoreLine ?>
>
</div>

<style type="text/css"><?php echo $this->getCarouselStyle( $atts, $id ) //@codingStandardsIgnoreLine ?></style>
