<?php
if ( ! defined( 'ABSPATH' ) ) { exit;
}

/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $el_class
 * Shortcode class
 * @var $this Vckit_Shortcode_Heading_Gradient
 */

$text =
$google_fonts =
$font_container =
$el_class =
$css =
$font_container_data =
$google_fonts_data =
$custom_fonts = '';

extract( $this->getAttributes( $atts ) );

extract( $this->getStyles( $el_class, $css, $google_fonts_data, $font_container_data, $atts ) );

// Set style for google fonts
$settings = get_option( 'wpb_js_google_fonts_subsets' );
if ( is_array( $settings ) && ! empty( $settings ) ) {
  $subsets = '&subset=' . implode( ',', $settings );
} else {
  $subsets = '';
}

if ( 'yes' == $custom_fonts ) {
  if ( isset( $google_fonts_data['values']['font_family'] ) ) {
      wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $google_fonts_data['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $google_fonts_data['values']['font_family'] . $subsets );
  }
}
//

// FIX MOE Inject gradient style
if ( empty( $atts['start_color'] ) || empty( $atts['end_color'] ) ) {
  $start_color =
  $end_color = '#000';
} else {
  $start_color = $atts['start_color'];
  $end_color = $atts['end_color'];
}

$gradient_style = 'color: ' . $start_color . ';
  background: linear-gradient(to bottom right,' . $start_color . ',' . $end_color . ');
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
  text-fill-color: transparent;';
$partial_style = 'style="' . esc_attr( $gradient_style );

// $styles manipulation
if ( ! empty( $styles ) ) {
  $style = $partial_style . esc_attr( implode( ';', $styles ) ) . '"';
} else {
  $style = $partial_style . '"';
}
//
?>

<div class="vckit-animated-typing-wrap <?php echo esc_attr( $css_class ) ?>">
  <<?php echo esc_attr( $font_container_data['values']['tag'] )?> <?php echo $style; // @codingStandardsIgnoreLine  ?>>
    <?php echo esc_html( $text ); ?>
  </div>
</<?php echo esc_attr( $font_container_data['values']['tag'] )?>>
