<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $el_class
 *
 * @var $content - shortcode content
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Gradient_Background
 */

$type_prefix = array();
$color_strip = array();

$background =
$direction =
$color =
$image =
$shape =
$size =
$coordinates = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$type_prefix[] = '-webkit-' . $type;
$type_prefix[] = '-o-' . $type;
$type_prefix[] = $type;

if ( 'custom' != $direction ) {
  $direction = str_replace( '_', ' ', $direction );
  $direction = 'to ' . $direction;
} else {
  $direction = $angle . 'deg,';
}

$color_strip = (array) vc_param_group_parse_atts( $color_strip );
$array_keys = array_keys( $color_strip );
$last_key = end( $array_keys );
foreach ( $color_strip as $key => $single_color ) {
  if ( ! isset( $single_color['color'] ) ) {
    $single_color['color'] =
    $single_color['position_stop'] = '';
  } elseif ( ! isset( $single_color['position_stop'] ) ) {
    $single_color['position_stop'] = '';
  }

  if ( $last_key != $key ) {
    $color .= $single_color['color'] . ' ' . $single_color['position_stop'] . ', ';
  } else {
    $color .= $single_color['color'] . ' ' . $single_color['position_stop'];
  }
}

$shape = $shape . ' ';
$size = $size . ' ';
$coordinates = 'at ' . $coordinates;

if ( '' != $image ) {
  $image = ', url( ' . "'" . esc_url( $this->getImageSrc( $image ) ) . "'" . ' )';
}

if ( 'linear-gradient' == $type ) {
  $shape =
  $size =
  $coordinates = '';
} else {
  $direction = '';
}

foreach ( $type_prefix as $t ) {
    $background .= 'background: '
    . $t
    . '('
    . $direction . $shape . $size . $coordinates
    . ', '
    . $color
    . ')'
    . $image
    . '; '
    ;
}

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
  $el_class,
  vc_shortcode_custom_css_class( $css ),
);
?>

<div class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>"
  style="<?php echo esc_attr( $background ); ?>">
    <?php echo wpb_js_remove_wpautop( $content ); //@codingStandardsIgnoreLine ?>
</div>
