<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $location_by
 * @var $address
 * @var $latitude
 * @var $longitude
 * @var $height
 * @var $zoom_level
 * @var $map_type
 * @var $map_style
 * @var $map_style_snippet
 * @var $el_class
 *
 * @var $marker_enable
 * @var $custom_icon_enable
 * @var $marker_icon
 * @var $infowindow_enable
 * @var $infowindow_layout
 * @var $infowindow_image
 * @var $infowindow_heading
 * @var $infowindow_heading_background
 * @var $content
 *
 * @var $zoom_control_disable
 * @var $street_view_control_disable
 * @var $draggable_disable
 * @var $double_click_zoom_disable
 * @var $scrollwheel_zoom_disable
 * @var $map_type_control_disable
 * @var $icon_clickable_disable
 *
 * Shortcode class
 * @var $this WPBakeryShortCode_Veac_Google_Map
 */

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

// Get extra class for multi maps.
$el_class = $this->getExtraClass( $el_class );

// Prepare $map_style_snippet for js.
if ( $map_style && '' !== $map_style ) {
  include "map-snippet/{$map_style}.php";
}

// Prepare $infowindow_content for js.
if ( $infowindow_layout && '' !== $infowindow_layout ) {
  include "infowindow-layout/{$infowindow_layout}.php";
}
?>

<div
<?php // @codingStandardsIgnoreStart ?>

  id="vckit-google-maps-<?php echo esc_attr( rand() ) ?>"
  class="legocreative-gmaps <?php echo esc_attr( trim( $el_class ) ); ?>"

<?php if ( 'address' === $location_by ) : ?>
  data-address="<?php echo $address; ?>"
<?php elseif ( 'coordinate' === $location_by ) : ?>
  data-latitude="<?php echo $latitude; ?>"
  data-longitude="<?php echo $longitude; ?>"
<?php endif; ?>

  data-height="<?php echo $height; ?>"
  data-zoom_level="<?php echo $zoom_level; ?>"
  data-map_type="<?php echo $map_type; ?>"
  data-map_style_snippet="<?php echo base64_encode($map_style_snippet); ?>"

<?php if ( $marker_enable ) : ?>
  data-marker_enable="true"
<?php if ( $custom_icon_enable && $marker_icon && '' !== $marker_icon ) : ?>
  data-marker_icon="<?php echo $this->getImageSrc( $marker_icon ); ?>"
<?php endif; ?>
<?php endif; ?>

<?php if ( $infowindow_enable ) : ?>
  data-infowindow_enable="true"
  data-infowindow_content="<?php echo base64_encode($infowindow_content); ?>"
<?php if ( '' !== $infowindow_heading ) : ?>
  data-infowindow_heading_background="<?php echo $infowindow_heading_background; ?>"
<?php endif; ?>
<?php endif; ?>

<?php if ( $zoom_control_disable ) : ?>
  data-zoom_control_disable="true"
<?php endif; ?>

<?php if ( $street_view_control_disable ) : ?>
  data-street_view_control_disable="true"
<?php endif; ?>

<?php if ( $draggable_disable ) : ?>
  data-draggable_disable="true"
<?php endif; ?>

<?php if ( $double_click_zoom_disable ) : ?>
  data-double_click_zoom_disable="true"
<?php endif; ?>

<?php if ( $scrollwheel_zoom_disable ) : ?>
  data-scrollwheel_zoom_disable="true"
<?php endif; ?>

<?php if ( $map_type_control_disable ) : ?>
  data-map_type_control_disable="true"
<?php endif; ?>

<?php if ( $icon_clickable_disable ) : ?>
  data-icon_clickable_disable="true"
<?php endif; ?>

<?php // @codingStandardsIgnoreEnd ?>
  >&nbsp;</div>
