<?php

/**
 * Create menu entry.
 *
 * @link       themelego.com
 * @since      1.0.0
 *
 * @package    Vckit
 * @subpackage Vckit/includes
 */

/**
 * Create menu entry.
 *
 * Registers a new menu item and uses the dependency passed into
 * the constructor in order to display the page corresponding to this menu item.
 *
 * @package    Vckit
 * @subpackage Vckit/includes
 * @author     ThemeLego <contact@themelego.com>
 */
class Vckit_Menu {

  function __construct() {
    $this->init();
  }

  function add_admin_menu() {
    add_menu_page(
      'Vckit options',
      'VCKit',
      'manage_options',
      'vckit',
      array(
        $this,
        'menu_page',
      ),
      VCKIT_PLUGIN_URL . '/assets/img/menu-icon.png'
    );
  }

  function menu_page() {
    // require_once( VCKIT_PLUGIN . 'include/settings/general.php' );
  }

  /**
   * Adds a menu for this plugin.
   */
  public function init() {
    add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
  }
}
