<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Video class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 *
 */

class Vckit_Shortcode_Video extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_video';
  protected $name = 'Video Modal';
  protected $desc = 'Embed YouTube, Vimeo player.';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/video-modal.png' ),
      'params' => array(
        array(
          'type'        => 'textfield',
          'heading'     => 'Video URL',
          'admin_label' => true,
          'param_name'  => 'url',
          'description' => __( 'Enter your video url (Youtube/Vimeo) here', 'legocreative' ),
          'value'       => 'http://vimeo.com/92033601',
        ),
        array(
          'type'        => 'textfield',
          'heading'     => 'Play button Scale',
          'admin_label' => false,
          'param_name'  => 'player_scale',
          'value'       => '1',
        ),
        array(
          'type'        => 'colorpicker',
          'heading'     => 'Play button Color',
          'admin_label' => false,
          'param_name'  => 'player_color',
          'description' => __( 'Color of video player', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'        => 'colorpicker',
          'heading'     => 'Play button Color on hover',
          'admin_label' => false,
          'param_name'  => 'player_color_hover',
          'description' => __( 'Color of video player on hover', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'        => 'textarea_raw_html',
          'heading'     => 'Play button SVG',
          'admin_label' => false,
          'param_name'  => 'svg',
          'description' => __( 'SVG source code (for developer only) for customize SVG, leave it empty if you use default button', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS box', 'legocreative' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Video extends WPBakeryShortCode {}
}
