<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Row.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Row extends Vckit_Shortcode_Base {

  protected $name = 'Custom VC Row';
  protected $default_enabled = false;

  /**
   * Parent plugin class
   *
   * @var VCAddonsKIT
   * @since  1.0
   */
  protected $plugin = null;

  public function __construct( $plugin ) {
    $this->plugin = $plugin;

    if ( 1 == vckit_get_option( 'vckit_row' ) ) {
      $this->registerParams();
      $this->hooks();
    }
  }

  public function hooks() {
    add_filter( 'vc_shortcode_set_template_vc_row', array( $this, 'customVcRowTemplate' ), 10, 1 );
  }

  public function customVcRowTemplate( $template ) {
    return vc_addons_kit()->path( 'vc_templates/' ) . 'vc_row.php';
  }

  public function getShortcode() {
    return 'vckit_row';
  }

  public function getDesc() {
    return 'Custom default visual composer by default';
  }

  public function registerParams() {
    $advanced_tab = __( 'Advanced Options', 'legocreative' );

    if ( function_exists( 'vc_add_params' ) ) {
      vc_add_params( 'vc_row', array(
        array(
          'type' => 'dropdown',
          'heading' => __( 'Background position', 'legocreative' ),
          'param_name' => 'row_advanced_bgposition',
          'group'     => $advanced_tab,
          'value' => array(
            __( 'Default', 'legocreative' ) => '',
            __( 'Left top', 'legocreative' ) => 'left top',
            __( 'Left center', 'js_composer' ) => 'left center',
            __( 'Left bottom', 'js_composer' ) => 'left bottom',
            __( 'Right top', 'legocreative' ) => 'right top',
            __( 'Right center', 'js_composer' ) => 'right center',
            __( 'Right bottom', 'js_composer' ) => 'right bottom',
            __( 'Center top', 'legocreative' ) => 'center top',
            __( 'Center center', 'js_composer' ) => 'center center',
            __( 'Center bottom', 'js_composer' ) => 'center bottom',
          ),
          'description' => __( 'Select alignment for content in a row.', 'legocreative' ),
          'admin_label' => false,
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Content alignment', 'legocreative' ),
          'param_name' => 'row_advanced_align',
          'group'     => $advanced_tab,
          'value' => array(
            __( 'Default', 'legocreative' ) => '',
            __( 'Center', 'js_composer' ) => 'center',
            __( 'Left', 'legocreative' ) => 'left',
            __( 'right', 'js_composer' ) => 'right',
          ),
          'description' => __( 'Select alignment for content in a row.', 'legocreative' ),
          'admin_label' => false,
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Background Color', 'legocreative' ),
          'param_name' => 'row_advanced_bgcolor',
          'group'     => $advanced_tab,
          'value' => array(
              __( 'Default', 'legocreative' ) => '',
              __( 'Blue', 'js_composer' ) => 'blue',
              __( 'Turquoise', 'js_composer' ) => 'turquoise',
              __( 'Pink', 'js_composer' ) => 'pink',
              __( 'Red', 'js_composer' ) => 'red',
              //__( 'Violet', 'js_composer' ) => 'violet',
              __( 'Grey', 'js_composer' ) => 'grey',
              __( 'Dark Grey', 'js_composer' ) => 'dark-grey',
              __( 'White', 'js_composer' ) => 'white',
              __( 'Black', 'js_composer' ) => 'black',
              __( 'Vista Blue', 'js_composer' ) => 'vista-blue',
              __( 'Green', 'js_composer' ) => 'green',
              __( 'Vista Green', 'js_composer' ) => 'vista-green',
              __( 'Ubax', 'js_composer' ) => 'ubax',
              __( 'Shamso', 'js_composer' ) => 'shamso',
              __( 'Maxamed', 'js_composer' ) => 'maxamed',
              __( 'Hagos', 'js_composer' ) => 'hagos',
              __( 'Magool', 'js_composer' ) => 'magool',
              __( 'Beca', 'js_composer' ) => 'beca',
              __( 'Meklit', 'js_composer' ) => 'meklit',
              __( 'Timiro', 'js_composer' ) => 'timiro',
              __( 'Mariame', 'js_composer' ) => 'mariame',
              __( 'Desta', 'js_composer' ) => 'desta',
              __( 'Aman', 'js_composer' ) => 'aman',
              __( 'Kafa', 'js_composer' ) => 'kafa',
              __( 'Ayana', 'js_composer' ) => 'ayana',
              __( 'Light Grey', 'js_composer' ) => 'light-grey',
              __( 'Light blue', 'js_composer' ) => 'light-blue',
              __( 'Light black', 'js_composer' ) => 'light-black',
            ),
          'description' => __( 'Select single bar background color.', 'legocreative' ),
          'admin_label' => false,
          'param_holder_class' => 'vckit-colored-dropdown',
        ),
        array(
          'group'     => $advanced_tab,
          'type'    => 'colorpicker',
          'heading'   => 'Overlay background color',
          'param_name'  => 'row_overlay_bg',
          'description' => esc_html( __( 'Choose an overlay color for background. Leave blank for none.', 'legocreative' ) ),
        ),
        array(
          'group'     => $advanced_tab,
          'type'    => 'dropdown',
          'heading'   => 'Background type',
          'param_name'  => 'row_bg_type',
          'description' => esc_html( __( 'Select background type, Choose the type of effect when the row is hovered on.', 'legocreative' ) ),
          'value'     => array(
            __( 'None', 'legocreative' )   => 'none',
            __( 'Mouse follow background', 'legocreative' )   => 'mouse',
            __( 'Tilt image', 'legocreative' )   => 'tilt',
            __( 'Google Maps', 'legocreative' )   => 'google',
            __( 'Particles', 'legocreative' )   => 'particles',
          ),
        ),
        array(
          'group'     => $advanced_tab,
          'type'        => 'attach_image',
          'heading'     => 'Image',
          'param_name'  => 'row_bg_image',
          'description' => __( 'Select your background image. <strong>Make sure that your image is of high resolution, we will resize the image to make it fit.</strong><br><strong>For optimal performance, try keeping your images close to 1600 x 900 pixels</strong>', 'legocreative' ),
          'dependency'  => array(
            'element' => 'row_bg_type',
            'value'   => array( 'mouse', 'tilt' ),
          ),
        ),
        //array(
          //'group'     => $advanced_tab,
          //'type'    => 'textfield',
          //'heading'   => __( 'Move/Tilt Amount', 'legocreative' ),
          //'param_name'  => 'row_bg_amount',
          //'value'     => '30',
          //'description' => esc_html( __( 'The move (pixels) or tilt (degrees) amount when the background is hovered on. For tilt types, the maximum allowed amount is <code>45 degrees</code>', 'legocreative' ) ),
          //'dependency'  => array(
            //'element' => 'row_bg_type',
            //'value'   => array( 'mouse', 'tilt' ),
          //)
        //),
        array(
          'group'     => $advanced_tab,
          'type'    => 'textfield',
          'heading'   => 'Coordinate',
          'param_name'  => 'rbm_coordinates',
          'value'     => '40.7590615,-73.969231',
          'description' => __( 'To learn how to get coordinates, visit <a href="https://support.google.com/maps/answer/18539?hl=en" target="_blank">https://support.google.com/maps/answer/18539?hl=en</a>', 'legocreative' ),
          'dependency'  => array(
            'element' => 'row_bg_type',
            'value'   => 'google',
          ),
        ),
        array(
          'group'     => $advanced_tab,
          'type'    => 'textfield',
          'heading'   => 'Map zoom',
          'param_name'  => 'rbm_zoom',
          'value'     => '13',
          'description' => esc_html( __( 'Map zoom level', 'legocreative' ) ),
          'dependency'  => array(
            'element' => 'row_bg_type',
            'value'   => 'google',
          ),
        ),
        array(
          'group'     => $advanced_tab,
          'type'    => 'dropdown',
          'heading'   => 'Map type',
          'param_name'  => 'rbm_type',
          'description' => esc_html( __( 'Choose a map type or a custom style map', 'legocreative' ) ),
          'value'     => array(
            'Roadmap'  => 'roadmap',
            'Satellite'  => 'satellite',
            'Hybrid'   => 'hybrid',
            'Terrain'  => 'terrain',
            'Custom ...' => 'custom',
          ),
          'dependency'  => array(
            'element' => 'row_bg_type',
            'value'   => 'google',
          ),
        ),
        array(
          'group'     => $advanced_tab,
          'type'    => 'textarea_raw_html',
          'heading'   => 'Map style',
          'param_name'  => 'rbm_style',
          'description' => __( 'To get the style snippet, visit <a href="https://snazzymaps.com" target="_blank">https://snazzymaps.com</a>.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'rbm_type',
            'value'   => 'custom',
          ),
          'value'     => '',
        ),
        array(
          'group'     => $advanced_tab,
          'type'    => 'textarea_raw_html',
          'heading'   => 'Particles json',
          'param_name'  => 'particles_json',
          'value'     => '',
          'description' => __( 'To get the config of particles, visit <a href="http://vincentgarreau.com/particles.js/" target="_blank">http://vincentgarreau.com/particles.js/</a>.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'row_bg_type',
            'value'   => 'particles',
          ),
        ),
      ));
    } // End if().
  }
}
