<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}


/**
 * Elegant Addons Shortcode Sample class.
 *
 * @since 1.0
 * @package Elegant Addons for VC
 */

class Vckit_Shortcode_QR_CODE extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_qr_code';
  protected $name = 'QR Code';
  protected $desc = 'Generate QR Code';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/qrcode.png' ),
      'params'      => array(
        array(
          'type' => 'textfield',
          'heading' => __( 'Text', 'legocreative' ),
          'param_name' => 'text',
          'description' => __( 'Enter text you want on QR code', 'legocreative' ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Width', 'legocreative' ),
          'param_name' => 'width',
          'std' => '150',
          'description' => __( 'Enter width of QR code icon in px', 'legocreative' ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Height', 'legocreative' ),
          'param_name' => 'height',
          'std' => '150',
          'description' => __( 'Enter height of QR code icon in px', 'legocreative' ),
          ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Background color', 'legocreative' ),
          'param_name' => 'bgcolor',
          'std' => '#ffffff',
          'description' => __( 'Select color as background color', 'legocreative' ),
          ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Data color', 'legocreative' ),
          'param_name' => 'datacolor',
          'std' => '#000000',
          'description' => __( 'Select color as data color', 'legocreative' ),
          ),
        array(
          'type'         => 'textfield',
          'heading'      => __( 'Extra class name', 'legocreative' ),
          'param_name'   => 'el_class',
          'description'  => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
          ),
        ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Veac_QR_Code extends WPBakeryShortCode {}
}
