<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * Elegant Addons Shortcode Message Box class.
 *
 * @since 1.0
 * @package Elegant Addons for VC
 */

class Vckit_Shortcode_Message_Box extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_message_box';
  protected $name = 'Message Boxes';
  protected $desc = 'Create Alert/Message box';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/message-boxes.png' ),
      'params'      => array(

        array(
          'type'        => 'textarea',
          'heading'     => __( 'Message', 'legocreative' ),
          'param_name'  => 'message',
          'value'       => 'Sample message',
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Message wrapper shape', 'legocreative' ),
          'param_name'  => 'message_shape',
          'std'         => 'rounded',
          'value'       => array(
            __( 'Squared', 'legocreative' ) => 'squared',
            __( 'Rounded', 'legocreative' ) => 'rounded',
            __( 'Circled', 'legocreative' ) => 'circled',
          ),
          'save_always' => true,
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Style', 'legocreative' ),
          'param_name'  => 'message_style',
          'std'         => 'classic',
          'value'       => array(
            __( 'Default', 'legocreative' )         => 'classic',
            __( 'Info', 'legocreative' )            => 'info',
            __( 'Info bright', 'legocreative' )     => 'info-bright',
            __( 'Success', 'legocreative' )         => 'success',
            __( 'Success bright', 'legocreative' )  => 'success-bright',
            __( 'Warning', 'legocreative' )         => 'warning',
            __( 'Warning bright', 'legocreative' )  => 'warning-bright',
            __( 'Danger', 'legocreative' )          => 'danger',
            __( 'Danger bright', 'legocreative' )   => 'danger-bright',

            __( 'Default reverse', 'legocreative' )         => 'classic-reverse',
            __( 'Info reverse', 'legocreative' )            => 'info-reverse',
            __( 'Info bright reverse', 'legocreative' )     => 'info-bright-reverse',
            __( 'Success reverse', 'legocreative' )         => 'success-reverse',
            __( 'Success bright reverse', 'legocreative' )  => 'success-bright-reverse',
            __( 'Warning reverse', 'legocreative' )         => 'warning-reverse',
            __( 'Warning bright reverse', 'legocreative' )  => 'warning-bright-reverse',
            __( 'Danger reverse', 'legocreative' )          => 'danger-reverse',
            __( 'Danger bright reverse', 'legocreative' )   => 'danger-bright-reverse',
          ),
          'save_always' => true,
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Close button', 'legocreative' ),
          'param_name'  => 'close_enable',
          'value'       => array(
            __( 'Enable', 'legocreative' ) => 'yes',
          ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Close button size', 'legocreative' ),
          'param_name'  => 'close_btn_size',
          'std'         => '16',
          'value'       => array(
            '12' => '12',
            '14' => '14',
            '16' => '16',
            '18' => '18',
            '20' => '20',
            '22' => '22',
            '24' => '24',
            '26' => '26',
            '28' => '28',
            '30' => '30',
          ),
          'dependency'  => array(
            'element'   => 'close_enable',
            'not_empty' => true,
          ),
          'save_always' => true,
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Animation when closed', 'legocreative' ),
          'param_name'  => 'fade_enable',
          'std'         => 'fade',
          'value'       => array(
            __( 'Fade', 'legocreative' ) => 'fade',
          ),
          'dependency'  => array(
            'element'   => 'close_enable',
            'not_empty' => true,
          ),
        ),

      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Message_Box extends WPBakeryShortCode {}
}
