<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}


/**
 * VC KIT Shortcode Interactive Navigation class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Interactive_Navigation extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_interactive_navigation';
  protected $name = 'Interactive Navigation';
  protected $desc = 'Inspiration for Navigation Indicators';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/interactive-navigation.png' ),
      'params'      => array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Navigation style', 'legocreative' ),
          'param_name' => 'style',
          'value'      => array(
            __( 'Ubax', 'legocreative' )  => 'ubax',
            __( 'Shamso', 'legocreative' )  => 'shamso',
            __( 'Maxamed', 'legocreative' )  => 'maxamed',
            __( 'Hagos', 'legocreative' )  => 'hagos',
            __( 'Zahi', 'legocreative' )  => 'zahi',
            __( 'Magool', 'legocreative' )  => 'magool',
            __( 'Xusni', 'legocreative' )  => 'xusni',
            __( 'Beca', 'legocreative' )  => 'beca',
            __( 'Etefu', 'legocreative' )  => 'etefu',
            __( 'Meklit', 'legocreative' )  => 'meklit',
            __( 'Timiro', 'legocreative' )  => 'timiro',
            __( 'Mariame', 'legocreative' )  => 'mariame',
            __( 'Desta', 'legocreative' )  => 'desta',
            __( 'Berta', 'legocreative' )  => 'berta',
            //__( 'Aman', 'legocreative' )  => 'aman',
            __( 'Kafa', 'legocreative' )  => 'kafa',
            __( 'Totit', 'legocreative' )  => 'totit',
            __( 'Ayana', 'legocreative' )  => 'ayana',
          ),
          'std'         => 'timiro',
          'description' => __( 'Select style for the navigation.', 'legocreative' ),
        ),
        array(
          'type' => 'param_group',
          'heading' => __( 'Navigators', 'legocreative' ),
          'param_name' => 'navigators',
          'description' => __( 'Enter your navigators list.', 'legocreative' ),
          'value' => urlencode( json_encode( array(
            array(
              'title' => 'Chapter 1',
              'hash'  => '#row1',
            ),
            array(
              'title' => 'Chapter 2',
              'hash'  => '#row2',
            ),
            array(
              'title' => 'Chapter 3',
              'hash'  => '#row3',
            ),
            array(
              'title' => 'Chapter 4',
              'hash'  => '#row4',
            ),
            array(
              'title' => 'Chapter 5',
              'hash'  => '#row5',
            ),
          ) ) ),
          'params' => array(
            array(
              'type' => 'textfield',
              'heading' => __( 'Title', 'legocreative' ),
              'param_name' => 'title',
              'description' => __( 'Enter text used as title of navigation.', 'legocreative' ),
              'admin_label' => true,
            ),
            array(
              'type' => 'textfield',
              'heading' => __( 'Hash', 'legocreative' ),
              'param_name' => 'hash',
              'description' => __( 'Enter hash of target, start with: #', 'legocreative' ),
              'admin_label' => true,
              'value' => '#',
            ),
          ),
        ),
        array(
          'type'             => 'textfield',
          'heading'          => __( 'Speed', 'legocreative' ),
          'param_name'       => 'speed',
          'value'            => '750',
          'description'      => __( 'Navigation speed', 'legocreative' ),
        ),

        array(
          'type'         => 'textfield',
          'heading'      => __( 'Extra class name', 'legocreative' ),
          'param_name'   => 'el_class',
          'description'  => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Interactive_Navigation extends WPBakeryShortCode {}
}

