<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Image Slider class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Image_Slider extends Vckit_Shortcode_Base {
  protected $shortcode = 'vckit_image_slider';
  protected $name = 'Image Slider';
  protected $desc = '';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/image-slider.png' ),
      'params' => array_merge(
        array(
          array(
            'type' => 'attach_images',
            'param_name' => 'list_image',
            'heading' => __( 'Images', 'legocreative' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => __( 'Image size', 'legocreative' ),
            'param_name' => 'img_size',
            'value' => 'full',
            'description' => __( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).', 'legocreative' ),
          ),
        ),
        $this->addCarouselOptions(),
        array(
          array(
            'type' => 'dropdown',
            'heading' => __( 'On click action (enable link)', 'legocreative' ),
            'param_name' => 'link',
            'value' => array(
              __( 'None', 'legocreative' ) => '',
              __( 'Open prettyPhoto', 'legocreative' ) => 'link_image',
            ),
            'description' => __( 'Select action for click action.', 'legocreative' ),
          ),
          array(
            'type'        => 'textfield',
            'param_name'  => 'el_class',
            'heading'     => __( 'Extra class name', 'legocreative' ),
            'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
          ),
          array(
            'type' => 'css_editor',
            'param_name' => 'css',
            'heading' => __( 'CSS box', 'legocreative' ),
            'group' => __( 'Design Options', 'legocreative' ),
          ),
        )
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Image_Slider extends WPBakeryShortCode {}
}
