<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Icon Showcase class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Icon_Showcase extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_icon_showcase';
  protected $name = 'Icon Showcase';
  protected $desc = 'Icon showcase by Vckit';

  public function params() {
    return array(
      'icon'                    => vc_addons_kit_assets( 'img/icons/showcase.png' ),
      'as_parent'               => array(
        'only' => 'vckit_icon_showcase_item',
      ),
      'show_settings_on_create' => true,
      'js_view'                 => 'VcColumnView',
      'params'                  => array(
        array(
          'type'        => 'dropdown',
          'admin_label' => true,
          'heading'     => __( 'Autoplay', 'legocreative' ),
          'param_name'  => 'autoplay',
          'value'       => array(
            'Yes' => 'yes',
            'No'  => 'no',
          ),
        ),
        array(
          'type'        => 'textfield',
          'admin_label' => true,
          'heading'     => __( 'Autoplay Interval (ms)', 'legocreative' ),
          'param_name'  => 'autoplay_interval',
          'description' => __( 'Default value is 3000.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Primary color', 'legocreative' ),
          'param_name' => 'primary_color',
          'edit_field_class' => 'vc_col-sm-4',
          'std'        => '#328fee',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Secondary color', 'legocreative' ),
          'param_name' => 'secondary_color',
          'edit_field_class' => 'vc_col-sm-4',
          'std'        => '#f3f3f3',
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
        array(
          'type'       => 'vckit_class',
          'param_name' => 'custom_class',
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
  class WPBakeryShortCode_Vckit_Icon_Showcase extends WPBakeryShortCodesContainer {
  }
}
