<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}


/**
 * VC KIT Shortcode Image Swap class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Heading_Gradient extends Vckit_Shortcode_Google_Fonts {

  protected $shortcode = 'vckit_heading_gradient';
  protected $name = 'Heading Gradient';
  protected $desc = 'Set Heading with gradient effect';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/heading-gradient.png' ),
      'params'      => array(
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Heading text', 'legocreative' ),
          'param_name'  => 'text',
          'value'       => 'Heading element',
          'description' => __( 'Enter the heading text', 'legocreative' ),
        ),
        array(
          'type' => 'font_container',
          'param_name' => 'font_container',
          'value' => 'tag:h2|text_align:center',
          'settings' => array(
            'fields' => array(
              'tag' => 'h2', // default value h2
              'text_align',
              'font_size',
              'line_height',
              'tag_description' => __( 'Select element tag.', 'legocreative' ),
              'text_align_description' => __( 'Select text alignment.', 'legocreative' ),
              'font_size_description' => __( 'Enter font size.', 'legocreative' ),
              'line_height_description' => __( 'Enter line height.', 'legocreative' ),
              'color_description' => __( 'Select heading color.', 'legocreative' ),
            ),
          ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Use theme default font family?', 'legocreative' ),
          'param_name' => 'use_theme_fonts',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Use font family from the theme.', 'legocreative' ),
        ),
        array(
          'type' => 'google_fonts',
          'param_name' => 'google_fonts',
          'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
          'settings' => array(
            'fields' => array(
              'font_family_description' => __( 'Select font family.', 'legocreative' ),
              'font_style_description' => __( 'Select font styling.', 'legocreative' ),
            ),
          ),
          'dependency' => array(
            'element' => 'use_theme_fonts',
            'value_not_equal_to' => 'yes',
          ),
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Starting color', 'legocreative' ),
          'param_name'       => 'start_color',
          'description'      => __( 'Choose the color for the starting gradient point', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Ending color', 'legocreative' ),
          'param_name'       => 'end_color',
          'description'      => __( 'Choose the color for the ending gradient point', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Heading_Gradient extends WPBakeryShortCode {}
}
