<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Sample class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */
class Vckit_Shortcodes_Heading_Effect extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_heading_effect';
  protected $name = 'Heading Effects';
  protected $desc = 'Animation for heading';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/heading-effects.png' ),
      'params'      => array(
        // ---General---
        array(
          'type'      => 'dropdown',
          'heading'   => __( 'Animation', 'legocreative' ),
          'param_name'  => 'animation',
          'value' => array(
           __( 'Kukuri', 'legocreative' )   => 'kukuri',
           __( 'Takiri', 'legocreative' )   => 'takiri',
           __( 'Surinami', 'legocreative' ) => 'surinami',
           __( 'Kumya', 'legocreative' )    => 'kumya',
           __( 'Manko', 'legocreative' )    => 'manko',
           __( 'Mallki', 'legocreative' )   => 'mallki',
           __( 'Ilin', 'legocreative' )     => 'ilin',
           __( 'Urpi', 'legocreative' )     => 'urpi',
          ),
          'description' => __( 'Choose your favourite animation here', 'legocreative' ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Text', 'legocreative' ),
          'param_name'  => 'whole_text',
          'value'       => __( 'Heading effect', 'legocreative' ),
          'description' => __( 'Change the whole content effect', 'legocreative' ),
          'dependency'  => array(
            'element' => 'animation',
            'value'   => array(
              'kukuri',
              'takiri',
              'kumya',
              'manko',
              'mallki',
              'urpi',
            ),
          ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'First-half text', 'legocreative' ),
          'param_name'  => 'first_half_text',
          'value'       => __( 'First-half heading', 'legocreative' ),
          'description' => __( 'Change the first-half content effect', 'legocreative' ),
          'dependency'  => array(
            'element' => 'animation',
            'value'   => array(
              'surinami',
              'ilin',
            ),
          ),
          'edit_field_class' => 'vc_col-sm-6',
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Second-half text', 'legocreative' ),
          'param_name'  => 'second_half_text',
          'value'       => __( 'Second-half heading', 'legocreative' ),
          'description' => __( 'Change the second-half content effect', 'legocreative' ),
          'dependency'  => array(
            'element' => 'animation',
            'value'   => array(
              'surinami',
              'ilin',
            ),
          ),
          'edit_field_class' => 'vc_col-sm-6',
        ),

        array(
          'type' => 'textfield',
          'heading' => __( 'Heading font size', 'legocreative' ),
          'param_name' => 'heading_size',
          'description' => __( 'Enter heading font-size. Ex: 20px, 2em, ...', 'legocreative' ),
        ),

        array(
          'type' => 'colorpicker',
          'heading' => __( 'Heading color', 'legocreative' ),
          'param_name' => 'heading_color',
        ),

        array(
          'type' => 'checkbox',
          'heading' => __( 'Use theme default font family?', 'js_composer' ),
          'param_name' => 'use_theme_fonts',
          'value' => array(
            __( 'Yes', 'js_composer' ) => 'yes',
          ),
          'description' => __( 'Use font family from the theme.', 'js_composer' ),
        ),

        array(
          'type' => 'google_fonts',
          'param_name' => 'google_fonts',
          'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal',
          'settings' => array(
            'fields' => array(
              'font_family_description' => __( 'Select font family.', 'js_composer' ),
              'font_style_description'  => __( 'Select font styling.', 'js_composer' ),
            ),
          ),
          'dependency' => array(
            'element' => 'use_theme_fonts',
            'value_not_equal_to' => 'yes',
          ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ),
        ),

      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Heading_Effect extends WPBakeryShortCode {}
}
