<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Samsung Grid class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Grid_Samsung extends Vckit_Shortcode_Grid {

  protected $grid = 'samsung';
  protected $name = 'Samsung Grid';
  protected $desc = 'Recreating Samsung\'s grid loading effect.';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/samsung-grid.png' ),
      'params' => array_merge( array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Effect', 'legocreative' ),
          'param_name' => 'effect',
          'value'      => array(
            __( 'Swipe Right', 'legocreative' )   => 'swipe-right',
            __( 'Swipe Down', 'legocreative' )   => 'swipe-down',
            __( 'Rotate', 'legocreative' )   => 'swipe-rotate',
          ),
          'std'         => 'swipe-right',
          'description' => __( 'Select samsung grid loading effect.', 'legocreative' ),
        ),
      ), $this->getBasicAtts() ),
    );
  }
}
