<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Contact Form7 class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Contact_Form7 extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_contact_form7';
  protected $name = 'Contact Form 7';
  protected $desc = 'Place Contact Form7';

  public function hooks() {
    parent::hooks();

    if ( 0 !== vckit_get_option( 'override_contact_form7_template' ) ) {
      add_filter( 'wpcf7_default_template', array( $this, 'wpcf7_default_template' ) , 10, 2 );
    }
  }

  public function maps() {
    if ( $this->isPluginActive() ) {
      parent::maps();
    }
  }

  public function wpcf7_default_template( $template, $prop ) {
    if ( 'form' == $prop ) {
      $template = sprintf( '
<div class="vc_row">
  <div class="vc_col-md-6">
    <span class="vckit-input">
      [text* your-name class:vckit-input__field]
      <label class="vckit-input__label" for="your-name">
        <span class="vckit-input__label-content"> %2$s %1$s </span>
      </label>
    </span>
  </div>
  <div class="vc_col-md-6">
    <span class="vckit-input">
      [email* your-email class:vckit-input__field]
      <label class="vckit-input__label" for="your-email">
        <span class="vckit-input__label-content"> %3$s %1$s </span>
      </label>
    </span>
  </div>
  <div class="vc_col-md-12">
    <span class="vckit-input">
      [text your-subject class:vckit-input__field]
      <label class="vckit-input__label" for="your-subject">
        <span class="vckit-input__label-content"> %4$s </span>
      </label>
    </span>
  </div>
  <div class="vc_col-md-12">
    <span class="vckit-input">
      [textarea your-message placeholder "%5$s"]
    </span>
  </div>
  <div class="vc_col-md-12">
    [submit "%6$s"]
  </div>
</div>',
      __( '(required)', 'contact-form-7' ),
      __( 'Your Name', 'contact-form-7' ),
      __( 'Your Email', 'contact-form-7' ),
      __( 'Subject', 'contact-form-7' ),
      __( 'Your Message', 'contact-form-7' ),
      __( 'Send', 'contact-form-7' ) );

      $template = trim( $template );
    } // End if().

    return $template;
  }

  /**
   * Map contact form 7
   *
   * @see include/classes/vendors/plugins/class-vc-vendor-contact-form7.php
   */
  public function params() {
    /**
     * Add Shortcode To Visual Composer
     */
    $cf7 = get_posts( 'post_type="wpcf7_contact_form"&numberposts=-1' ); // @codingStandardsIgnoreLine

    $contact_forms = array();
    if ( $cf7 ) {
      foreach ( $cf7 as $cform ) {
        $contact_forms[ $cform->post_title ] = $cform->ID;
      }
    } else {
      $contact_forms[ __( 'No contact forms found', 'legocreative' ) ] = 0;
    }

    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/contact-form-7.png' ),
      'params' => array(
        array(
          'type' => 'dropdown',
          'heading' => __( 'Select contact form', 'legocreative' ),
          'param_name' => 'id',
          'value' => $contact_forms,
          'save_always' => true,
          'description' => __( 'Choose previously created contact form from the drop down list.', 'legocreative' ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Form style', 'legocreative' ),
          'param_name' => 'style',
          'value'      => array(
            __( 'Basic', 'legocreative' )  => 'basic',
            __( 'Haruki', 'legocreative' )  => 'haruki',
            __( 'Hoshi', 'legocreative' ) => 'hoshi',
            __( 'Kuro', 'legocreative' ) => 'kuro',
            __( 'Jiro', 'legocreative' )   => 'jiro',
            __( 'Minoru', 'legocreative' ) => 'minoru',
            __( 'Yoko', 'legocreative' ) => 'yoko',
            __( 'Hideo', 'legocreative' )  => 'hideo',
            __( 'Kyo', 'legocreative' )  => 'kyo',
            __( 'Akira', 'legocreative' )  => 'akira',
            __( 'Ichiro', 'legocreative' )   => 'ichiro',
            __( 'Juro', 'legocreative' )  => 'juro',
            __( 'Madoka', 'legocreative' ) => 'madoka',
            __( 'Kaede', 'legocreative' )  => 'kaede',
            __( 'Isao', 'legocreative' ) => 'isao',
            __( 'Manami', 'legocreative' ) => 'manami',
            __( 'Nariko', 'legocreative' )  => 'nariko',
            __( 'Nao', 'legocreative' )   => 'nao',
            __( 'Yoshiko', 'legocreative' ) => 'yoshiko',
            __( 'Shoko', 'legocreative' )  => 'shoko',
            __( 'Chisato', 'legocreative' )  => 'chisato',
            __( 'Makiko', 'legocreative' )   => 'makiko',
            __( 'Sae', 'legocreative' ) => 'sae',
            __( 'Kozakura', 'legocreative' ) => 'kozakura',
            __( 'Fumi', 'legocreative' )  => 'fumi',
            __( 'Ruri', 'legocreative' )  => 'ruri',
            __( 'Kohana', 'legocreative' )  => 'kohana',
          ),
          'std'         => 'basic',
          'description' => __( 'Select style for your form.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Primary color', 'legocreative' ),
          'param_name' => 'primary_color',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Secondary color', 'legocreative' ),
          'param_name' => 'secondary_color',
          'dependency' => array(
            'element' => 'style',
            'value_not_equal_to' => array(
              'haruki',
              'kuro',
              'jiro',
              'yoko',
              'kyo',
              'akira',
              'ichiro',
              'madoka',
              'shoko',
              'makiko',
              'sae',
              'fumi',
              'kohana',
            ),
          ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Input color', 'legocreative' ),
          'param_name' => 'input_color',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Label color', 'legocreative' ),
          'param_name' => 'label_color',
          'dependency' => array(
            'element' => 'style',
            'value_not_equal_to' => array(),
          ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Button padding', 'legocreative' ),
          'param_name' => 'button_padding',
        ),
        array(
          'type'       => 'textfield',
          'heading'    => __( 'Extra class name', 'legocreative' ),
          'param_name' => 'el_class',
          'description'       => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),
        array(
          'type'       => 'vckit_class',
          'heading'    => '',
          'param_name' => 'custom_class',
          'value'      => '',
        ),
      ),
    );
  }

  public function isPluginActive() {
    include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Require plugin.php to use is_plugin_active() below
    if ( is_plugin_active( 'contact-form-7/wp-contact-form-7.php' ) || defined( 'WPCF7_PLUGIN' ) ) {
      return true;
    }
    return false;
  }

  public function getCustomCSS( $atts ) {
    $primary_color =
    $secondary_color =
    $style =
    $label_color =
    $input_color =
    $button_padding =
    $custom_class = '';

    extract( $atts );

    $css = '';
    if ( $custom_class ) {
      if ( ! $style ) {
        $style = 'basic'; // Fix default error
      }

      $custom_class = '.vckit-contact.vckit-contact-' . $style . '.' . $custom_class;

      // @codingStandardsIgnoreStart
      if ( $primary_color ) {

        // Wrapper
        if ( preg_match( '/kaede|fumi/', $style ) ) {
          $css .= $custom_class . ' .vckit-input '
            . '{ border-color: ' . $primary_color . ' }';
        }
        if ( preg_match( '/makiko/', $style ) ) {
          $css .= $custom_class . ' .vckit-input '
            . '{ background-color: ' . $primary_color . ' }';
        }

        // Input
        if ( preg_match( '/basic|kyo|chisato|makiko|kohana/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__field '
            . '{ border-color: ' . $primary_color . ' }';
        }
        if ( preg_match( '/minoru|ichiro|yoshiko/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__field '
            . '{ background-color: ' . $primary_color . ' }';
        }

        // Label Before
        if ( preg_match( '/haruki|yoko|hideo|isao/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label::before '
            . '{ background-color: ' . $primary_color . ' }';
        }
        if ( preg_match( '/hoshi|kuro|jiro|akira|ichiro|juro|nariko|madoka/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label::before '
            . '{ border-color: ' . $primary_color . ' }';
        }

        // Label After
        if ( preg_match( '/haruki|yoko|jiro|kyo|manami|sae|ruri/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label::after '
            . '{ background-color: ' . $primary_color . ' }';
        }
        if ( preg_match( '/kuro|madoka/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label::after '
            . '{ border-color: ' . $primary_color . ' }';
        }

        // Textarea
        if ( preg_match( '/minoru|yoshiko|kozakura/', $style ) ) {
          $css .= $custom_class . ' textarea '
            . '{ background-color: ' . $primary_color . ' }';
        }
        if ( preg_match( '/jiro|yoko|ichiro/', $style ) ) {
          $css .= $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ background-color: ' . $primary_color . ' }';
        }
        if ( preg_match( '/basic|kyo/', $style ) ) {
          $css .= $custom_class . ' textarea '
            . '{ border-color: ' . $primary_color . ' }';
        }

        // Submit button
        if ( preg_match( '/minoru|hideo|yoshiko|makiko|kozakura/', $style ) ) {
          $css .= $custom_class . ' input[type="submit"] '
            . ' { background-color: ' . $primary_color . ' }';
        }
        if ( preg_match( '/jiro|minoru|yoko|kyo|ichiro|juro/', $style ) ) {
          $css .= $custom_class . ' input[type="submit"]:hover, '
            . $custom_class . ' input[type="submit"]:focus '
            . '{ background-color: ' . $primary_color . ' }';
        }
        if ( preg_match( '/madoka/', $style ) ) {
          $css .= $custom_class . ' input[type="submit"]:hover, '
            . $custom_class . ' input[type="submit"]:focus '
            . '{ border-color: ' . $primary_color . ' }';
        }

        // SVG
        if ( preg_match( '/nao|shoko/', $style ) ) {
          $css .= $custom_class . ' .graphic '
            . ' { stroke: ' . $primary_color . ' }';
        }
        if ( preg_match( '/kozakura/', $style ) ) {
          $css .= $custom_class . ' .graphic '
            . ' { fill: ' . $primary_color . ' }';
        }

        if ( preg_match( '/madoka/', $style ) ) {
          $css .= $custom_class . ' .vckit-input--filled .vckit-input__label:before, '
            . $custom_class . ' .vckit-input--filled .vckit-input__label:after, '
            . $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ border-color: ' . $primary_color . ' }';
        }

        $css .= $custom_class . ' textarea { border-color: ' . $primary_color . '}';
        $css .= $custom_class . ' input[type="submit"] { border-color: ' . $primary_color . ' }';
      }

      if ( $secondary_color ) {
        if ( preg_match( '/basic|hoshi|minoru/', $style ) ) {
          $css .= $custom_class . ' .vckit-input--filled .vckit-input__field, '
            . $custom_class . ' .vckit-input__field:focus, '
            . $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ border-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/hoshi/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label::after'
            . '{ border-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/minoru/', $style ) ) {
          $css .= $custom_class . ' .vckit-input--filled .vckit-input__field, '
            . $custom_class . ' .vckit-input__field:focus '
            . '{ box-shadow: 0px 0px 0px 1px ' . $secondary_color . ' }';
        }

        if ( preg_match( '/hideo/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__field, '
            . $custom_class . ' textarea '
            . '{ background-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/juro/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label, '
            . $custom_class . ' textarea, '
            . $custom_class . ' input[type="submit"] '
            . '{ background-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/kaede/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label, '
            . $custom_class . ' textarea, '
            . $custom_class . ' input[type="submit"] '
            . '{ background-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/isao/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__field:focus + .vckit-input__label:before, '
            . $custom_class . ' .vckit-input--filled .vckit-input__label:before '
            . '{ background-color: ' . $secondary_color . ' }';
          $css .= $custom_class . ' .vckit-input__field:focus + .vckit-input__label-content, '
            . $custom_class . ' .vckit-input--filled .vckit-input__label-content '
            . '{ color: ' . $secondary_color . ' }';
          $css .= $custom_class . ' .vckit-input--filled .vckit-input__label:before, '
            . $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ border-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/manami/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label::before, '
            . $custom_class . ' .vckit-input--filled .vckit-input__label:before, '
            . $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ background-color: ' . $secondary_color . ' }';
          $css .= $custom_class . ' .vckit-input--filled .vckit-input__label:before, '
            . $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ border-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/nariko/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label::before, '
            . $custom_class . ' .vckit-input--filled .vckit-input__label:before, '
            . $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ background-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/yoshiko/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__field:focus, '
            . $custom_class . ' .vckit-input--filled .vckit-input__field, '
            . $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ border-color: ' . $secondary_color . ' }';
          $css .= $custom_class . ' .vckit-input__field:focus + .vckit-input__label .vckit-input__label-content, '
            . $custom_class . ' .vckit-input--filled .vckit-input__label-content '
            . '{ color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/chisato/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__field:focus, '
            . $custom_class . ' .vckit-input--filled .vckit-input__field, '
            . $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ border-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/kozakura/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__field:focus ~ .graphic, '
            . $custom_class . ' .vckit-input--filled .graphic '
            . '{ fill: ' . $secondary_color . ' }';
          $css .= $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ background-color: ' . $secondary_color . ' }';
        }

        if ( preg_match( '/ruri/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__field:focus + .vckit-input__label::after, '
            . $custom_class . ' .vckit-input--filled .vckit-input__label::after '
            . '{ background-color: ' . $secondary_color . ' }';
          $css .= $custom_class . ' .vckit-input__field:focus + .vckit-input__label .vckit-input__label-content, '
            . $custom_class . ' .vckit-input--filled .vckit-input__label .vckit-input__label-content '
            . '{ color: ' . $secondary_color . ' }';
          $css .= $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ border-color: ' . $secondary_color . ' }';
        }

        // SVG
        if ( preg_match( '/nao/', $style ) ) {
          $css .= $custom_class . ' .vckit-input--filled .graphic '
            . ' { stroke: ' . $secondary_color . ' }';
          $css .= $custom_class . ' textarea.vckit-textarea--filled, '
            . $custom_class . ' textarea:focus '
            . '{ border-color: ' . $secondary_color . ' }';
        }

        $css .= $custom_class . ' input[type="submit"]:hover { border-color: ' . $secondary_color . ' }';
        $css .= $custom_class . ' input[type="submit"]:hover { color: ' . $secondary_color . ' }';
      }

      if ( $label_color ) {
        if ( preg_match( '/hideo/', $style ) ) {
          $css .= $custom_class . ' .vckit-input__label::after'
            . '{ color: ' . $label_color . ' }';
        }

        $css .= $custom_class . ' .vckit-input__label, '
          . $custom_class . ' .vckit-input__label-content, '
          . $custom_class . ' textarea::-webkit-input-placeholder '
          . '{ color: ' . $label_color . ' }';

        $css .= $custom_class . ' input[type="submit"] { color: ' . $label_color . ' }';
      }

      if ( $input_color ) {
        $css .= $custom_class . ' .vckit-input__field, '
          . $custom_class . ' textarea '
          . ' { color: ' . $input_color . ' }';
      }

      if ( $button_padding ) {
        $css .= $custom_class . ' input[type="submit"] { padding: ' . $button_padding . ' }';
      }
      // @codingStandardsIgnoreEnd
    } // End if().

    return $css;
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Contact_Form7 extends WPBakeryShortCode {}
}
