<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Animated Block class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Animated_Block extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_animated_block';
  protected $name = 'Animation Block';
  protected $desc = 'Fade in, scale in, ..';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/animation-block.png' ),
      'content_element' => true,
      'is_container' => true,
      'custom_markup' => '',
      'js_view' => 'VcColumnView',
      'params' => array(
        array(
          'type' => 'animation_style',
          'heading' => __( 'Typing animation', 'legocreative' ),
          'param_name' => 'css_animation',
          'settings' => array(
            'type' => array(
              'in',
              'other',
            ),
          ),
          'description' => __( 'Select "animation in" for uppear item.', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Animation delay', 'legocreative' ),
          'param_name'  => 'delay',
          'value'       => '0',
          'description' => __( 'Set animation delay in seconds. for example: 1.2s', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS box', 'legocreative' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ),
    );
  }
}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
  class WPBakeryShortCode_Vckit_Animated_Block extends WPBakeryShortCodesContainer {
  }
}

