<?php
  /**
   * This is just a page shown infor
   * We do not need to focus on it
   */
  $pluginData = get_plugin_data( VCKIT_PLUGIN );
  $basename = vc_addons_kit()->basename;
  //@codingStandardsIgnoreStart
?>

<div class="vckit-setting-about">
  <h2 class="vckit-setting-title"> Welcome to Visual Composer Addons KIT <?php echo vc_addons_kit()->__get( 'version' ) ?></h2>

  <div class="vckit-setting-message">
    Congratulations! You are about to use most powerful addons for WPBakery Page Builder (Visual Composer) to improve your Wordpress site - kit addons plugin with Frontend and Backend editors by ThemeLego.
  </div>

  <div class="updated" style="border-left-color: #3498db">
    <p>
    <img src="<?php echo esc_url( vc_addons_kit_assets( 'img/logo.png' ) ) ?>" style="display: block; margin-bottom: 10px"/>
      <strong><?php echo sprintf( __( 'Thank you for using %s!', $basename ), $pluginData['Name'] ) ?></strong><br>

      <?php echo __( 'Now just edit your pages, add shortcode in Addons KIT list, and style it, all in Visual Composer.', $basename ) ?>
      <br>

      <?php echo __( 'If you need any support, you can leave us a ticket in our support site. The link to our support site is also listed in the plugin details for future reference.', $basename ) ?>
      <br>

      <a href="http://support.themelego.com?utm_source=<?php echo urlencode( $pluginData['Name'] ) ?>&utm_medium=setting_notice" class="legocreative_ask_rate button button-default" style="margin: 10px 0;" target="_blank">
        <?php echo __( 'Visit our support site', $basename ) ?>
      </a>
       or send us an email to <a href="mailto:support@themelego.com">support@themelego.com</a>
    </p>
  </div>

  <div class="vckit-about-item">
    <div class="vckit-about-header">
      <h3><?php echo __( 'System requirements', 'legocreative' ) ?></h3>
    </div>
    <div class="vckit-about-body">

      <?php

      $update = '';

      // icons php info
      $true  = '<i class="vckit-php-info-icon dashicons dashicons-yes"></i>';
      $false = '<i class="vckit-php-info-icon dashicons dashicons-no"></i>';
      $recommended = '<i class="vckit-php-info-icon dashicons dashicons-no vckit-recommended-icon"></i>';
      // Wordpress version
      global $wp_version;
      $wp_version_bool = (version_compare($wp_version,  '4.4.0') >=  0) ? true : false;
      $wp_version_icon = ($wp_version_bool) ? $true : $false;
      // Visual Composer version
      $vc_version = (defined('WPB_VC_VERSION')) ? WPB_VC_VERSION : null;
      $vc_version_bool = (class_exists('Vc_Manager') && version_compare($vc_version,  '4.7.4') >=  0) ? true : false;
      $vc_version_icon = ($vc_version_bool) ? $true : $false;
      // php memory limit
      $mem_limit = ini_get('memory_limit');
      $mem_limit_bytes = vckit_setting_to_bytes($mem_limit);
      $mem_limit_bool  = ((int) $mem_limit_bytes >= 64 * 1024 * 1024)  ? true : false;
      $mem_limit_icon  = ($mem_limit_bool) ? $true : $recommended;
      // php max upload file size
      $upload_max_filesize = ini_get('upload_max_filesize');
      $upload_max_filesize_bytes = vckit_setting_to_bytes($upload_max_filesize);
      $upload_max_filesize_bool  = ((int) $upload_max_filesize_bytes >= 64 * 1024 * 1024) ? true : false;
      $upload_max_filesize_icon  = ($upload_max_filesize_bool) ? $true : $recommended;
      // php mmax post size
      $post_max_size = ini_get('post_max_size');
      $post_max_size_bytes = vckit_setting_to_bytes($post_max_size);
      $post_max_size_bool  = ((int) $post_max_size_bytes >= 64 * 1024 * 1024) ? true : false;
      $post_max_size_icon  = ($post_max_size_bool) ? $true : $recommended;
      // php version
      $php_version = PHP_VERSION;
      $php_version_bool = (version_compare($php_version,  '5.3.0') >=  0) ? true : false;
      $php_version_icon = ($php_version_bool) ? $true : $false;

      $msg_reco = '<span class="vckit-info-recommended"> ('.__( 'recommended', 'legocreative' ).')</span>';
      $msg_mand = '<span class="vckit-info-needed"> ('.__( 'required', 'legocreative' ).')</span>';

      $update .= $wp_version_icon.'<div class="vckit-php-info">'. __( 'Wordpress Version', 'legocreative' ) .'</div><span class="vckit-php-info-value">v'. $wp_version .'</span>';
      $update .= (!$wp_version_bool) ?'<span class="vckit-php-info-value-needed">v4.4.X</span>'.$msg_mand : '';
      $update .= '<div class="lemb-spacer" style="height: 7px"></div>';
      $update .= (class_exists('Vc_Manager')) ? $vc_version_icon.'<div class="vckit-php-info">'. __( 'Visual Composer Version', 'legocreative' ) .'</div><span class="vckit-php-info-value">v'. $vc_version .'</span>' : '';
      $update .= (class_exists('Vc_Manager') && !$vc_version_bool) ? '<span class="vckit-php-info-value-needed">v4.7.4</span>'.$msg_mand : '';
      $update .= (class_exists('Vc_Manager')) ? '<div class="lemb-spacer" style="height: 7px"></div>' : '';
      $update .= $mem_limit_icon.'<div class="vckit-php-info">'. __( 'Memory Limit', 'legocreative' ) .'</div><span class="vckit-php-info-value">'. $mem_limit .'</span>';
      $update .= (!$mem_limit_bool) ?'<span class="vckit-php-info-value-recommended">64M</span>'.$msg_reco : '';
      $update .= '<div class="lemb-spacer" style="height: 7px"></div>';
      $update .= $upload_max_filesize_icon.'<div class="vckit-php-info">'. __( 'Upload Max. Filesize', 'legocreative' ) .'</div><span class="vckit-php-info-value">'. $upload_max_filesize .'</span>';
      $update .= (!$upload_max_filesize_bool) ?'<span class="vckit-php-info-value-recommended">64M</span>'.$msg_reco : '';
      $update .= '<div class="lemb-spacer" style="height: 7px"></div>';
      $update .= $post_max_size_icon.'<div class="vckit-php-info">'. __( 'Max. Post Size', 'legocreative' ) .'</div><span class="vckit-php-info-value">'. $post_max_size .'</span>';
      $update .= (!$post_max_size_bool) ?'<span class="vckit-php-info-value-recommended">64M</span>'.$msg_reco : '';
      $update .= '<div class="lemb-spacer" style="height: 7px"></div>';
      $update .= $php_version_icon.'<div class="vckit-php-info">'. __( 'PHP version', 'legocreative' ) .'</div><span class="vckit-php-info-value">v'. $php_version .'</span>';
      $update .= (!$php_version_bool) ?'<span class="vckit-php-info-value-needed">v5.4.0</span>'.$msg_mand : '';

    echo $update;

    //@codingStandardsIgnoreStart
    ?>

    </div>
  </div>

  <div class="vckit-about-item">
    <div class="vckit-about-header">
      <h3><?php echo __( 'Update history', 'legocreative' ) ?></h3>
    </div>
    <div class="vckit-about-body">
      <pre>
      <?php
      $fh = fopen( VCKIT_PLUGIN_DIR . '/History.md','r' );
      while ($line = fgets($fh)) {
        // <... Do your work with the line ...>
        echo($line);
      }
      fclose($fh);
      ?>
      </pre>
    </div>
  </div>
</div>
