/* global WPCOM_sharing_counts, grecaptcha */
var sharing_js_options;
if ( sharing_js_options && sharing_js_options.counts ) {
	var WPCOMSharing = {
		done_urls: [],
		get_counts: function () {
			var url, requests, id, service, service_request;

			if ( 'undefined' === typeof WPCOM_sharing_counts ) {
				return;
			}

			for ( url in WPCOM_sharing_counts ) {
				id = WPCOM_sharing_counts[ url ];

				if ( 'undefined' !== typeof WPCOMSharing.done_urls[ id ] ) {
					continue;
				}

				requests = {
					// Pinterest handles share counts for both http and https
					pinterest: [
						window.location.protocol +
							'//api.pinterest.com/v1/urls/count.json?callback=WPCOMSharing.update_pinterest_count&url=' +
							encodeURIComponent( url ),
					],
					// Facebook protocol summing has been shown to falsely double counts, so we only request the current URL
					facebook: [
						window.location.protocol +
							'//graph.facebook.com/?callback=WPCOMSharing.update_facebook_count&ids=' +
							encodeURIComponent( url ),
					],
				};

				for ( service in requests ) {
					if ( ! jQuery( 'a[data-shared=sharing-' + service + '-' + id + ']' ).length ) {
						continue;
					}

					while ( ( service_request = requests[ service ].pop() ) ) {
						jQuery.getScript( service_request );
					}

					if ( sharing_js_options.is_stats_active ) {
						WPCOMSharing.bump_sharing_count_stat( service );
					}
				}

				WPCOMSharing.done_urls[ id ] = true;
			}
		},

		// get the version of the url that was stored in the dom (sharing-$service-URL)
		get_permalink: function ( url ) {
			if ( 'https:' === window.location.protocol ) {
				url = url.replace( /^http:\/\//i, 'https://' );
			} else {
				url = url.replace( /^https:\/\//i, 'http://' );
			}

			return url;
		},
		update_facebook_count: function ( data ) {
			var url, permalink;

			if ( ! data ) {
				return;
			}

			for ( url in data ) {
				if (
					! data.hasOwnProperty( url ) ||
					! data[ url ].share ||
					! data[ url ].share.share_count
				) {
					continue;
				}

				permalink = WPCOMSharing.get_permalink( url );

				if ( ! ( permalink in WPCOM_sharing_counts ) ) {
					continue;
				}

				WPCOMSharing.inject_share_count(
					'sharing-facebook-' + WPCOM_sharing_counts[ permalink ],
					data[ url ].share.share_count
				);
			}
		},
		update_pinterest_count: function ( data ) {
			if ( 'undefined' !== typeof data.count && data.count * 1 > 0 ) {
				WPCOMSharing.inject_share_count(
					'sharing-pinterest-' + WPCOM_sharing_counts[ data.url ],
					data.count
				);
			}
		},
		inject_share_count: function ( id, count ) {
			var $share = jQuery( 'a[data-shared=' + id + '] > span' );
			$share.find( '.share-count' ).remove();
			$share.append(
				'<span class="share-count">' + WPCOMSharing.format_count( count ) + '</span>'
			);
		},
		format_count: function ( count ) {
			if ( count < 1000 ) {
				return count;
			}
			if ( count >= 1000 && count < 10000 ) {
				return String( count ).substring( 0, 1 ) + 'K+';
			}
			return '10K+';
		},
		bump_sharing_count_stat: function ( service ) {
			new Image().src =
				document.location.protocol +
				'//pixel.wp.com/g.gif?v=wpcom-no-pv&x_sharing-count-request=' +
				service +
				'&r=' +
				Math.random();
		},
	};
}

( function ( $ ) {
	var $body, $sharing_email;

	$.fn.extend( {
		share_is_email: function () {
			return /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i.test(
				this.val()
			);
		},
	} );

	$body = $( document.body ).on( 'post-load', WPCOMSharing_do );
	$( document ).ready( function () {
		$sharing_email = $( '#sharing_email' );
		$body.append( $sharing_email );
		WPCOMSharing_do();
	} );

	function WPCOMSharing_do() {
		var $more_sharing_buttons;
		if ( 'undefined' !== typeof WPCOMSharing ) {
			WPCOMSharing.get_counts();
		}
		$more_sharing_buttons = $( '.sharedaddy a.sharing-anchor' );

		$more_sharing_buttons.click( function () {
			return false;
		} );

		$( '.sharedaddy a' ).each( function () {
			if ( $( this ).attr( 'href' ) && $( this ).attr( 'href' ).indexOf( 'share=' ) !== -1 ) {
				$( this ).attr( 'href', $( this ).attr( 'href' ) + '&nb=1' );
			}
		} );

		// Show hidden buttons

		// Touchscreen device: use click.
		// Non-touchscreen device: use click if not already appearing due to a hover event
		$more_sharing_buttons.on( 'click', function () {
			var $more_sharing_button = $( this ),
				$more_sharing_pane = $more_sharing_button.parents( 'div:first' ).find( '.inner' );

			if ( $more_sharing_pane.is( ':animated' ) ) {
				// We're in the middle of some other event's animation
				return;
			}

			if ( true === $more_sharing_pane.data( 'justSlid' ) ) {
				// We just finished some other event's animation - don't process click event so that slow-to-react-clickers don't get confused
				return;
			}

			$sharing_email.slideUp( 200 );

			$more_sharing_pane
				.css( {
					left: $more_sharing_button.position().left + 'px',
					top: $more_sharing_button.position().top + $more_sharing_button.height() + 3 + 'px',
				} )
				.slideToggle( 200 );
		} );

		if ( document.ontouchstart === undefined ) {
			// Non-touchscreen device: use hover/mouseout with delay
			$more_sharing_buttons.hover(
				function () {
					var $more_sharing_button = $( this ),
						$more_sharing_pane = $more_sharing_button.parents( 'div:first' ).find( '.inner' ),
						timer;

					if ( ! $more_sharing_pane.is( ':animated' ) ) {
						// Create a timer to make the area appear if the mouse hovers for a period
						timer = setTimeout( function () {
							var handler_item_leave,
								handler_item_enter,
								handler_original_leave,
								handler_original_enter,
								close_it;

							$sharing_email.slideUp( 200 );

							$more_sharing_pane.data( 'justSlid', true );
							$more_sharing_pane
								.css( {
									left: $more_sharing_button.position().left + 'px',
									top:
										$more_sharing_button.position().top + $more_sharing_button.height() + 3 + 'px',
								} )
								.slideDown( 200, function () {
									// Mark the item as have being appeared by the hover
									$more_sharing_button.data( 'hasoriginal', true ).data( 'hasitem', false );

									setTimeout( function () {
										$more_sharing_pane.data( 'justSlid', false );
									}, 300 );

									$more_sharing_pane
										.mouseleave( handler_item_leave )
										.mouseenter( handler_item_enter );
									$more_sharing_button
										.mouseleave( handler_original_leave )
										.mouseenter( handler_original_enter );
								} );

							// The following handlers take care of the mouseenter/mouseleave for the share button and the share area - if both are left then we close the share area
							handler_item_leave = function () {
								$more_sharing_button.data( 'hasitem', false );

								if ( $more_sharing_button.data( 'hasoriginal' ) === false ) {
									var timer = setTimeout( close_it, 800 );
									$more_sharing_button.data( 'timer2', timer );
								}
							};

							handler_item_enter = function () {
								$more_sharing_button.data( 'hasitem', true );
								clearTimeout( $more_sharing_button.data( 'timer2' ) );
							};

							handler_original_leave = function () {
								$more_sharing_button.data( 'hasoriginal', false );

								if ( $more_sharing_button.data( 'hasitem' ) === false ) {
									var timer = setTimeout( close_it, 800 );
									$more_sharing_button.data( 'timer2', timer );
								}
							};

							handler_original_enter = function () {
								$more_sharing_button.data( 'hasoriginal', true );
								clearTimeout( $more_sharing_button.data( 'timer2' ) );
							};

							close_it = function () {
								$more_sharing_pane.data( 'justSlid', true );
								$more_sharing_pane.slideUp( 200, function () {
									setTimeout( function () {
										$more_sharing_pane.data( 'justSlid', false );
									}, 300 );
								} );

								// Clear all hooks
								$more_sharing_button
									.unbind( 'mouseleave', handler_original_leave )
									.unbind( 'mouseenter', handler_original_enter );
								$more_sharing_pane
									.unbind( 'mouseleave', handler_item_leave )
									.unbind( 'mouseenter', handler_item_leave );
								return false;
							};
						}, 200 );

						// Remember the timer so we can detect it on the mouseout
						$more_sharing_button.data( 'timer', timer );
					}
				},
				function () {
					// Mouse out - remove any timer
					$more_sharing_buttons.each( function () {
						clearTimeout( $( this ).data( 'timer' ) );
					} );
					$more_sharing_buttons.data( 'timer', false );
				}
			);
		} else {
			$( document.body ).addClass( 'jp-sharing-input-touch' );
		}

		$( document ).click( function () {
			// Click outside
			// remove any timer
			$more_sharing_buttons.each( function () {
				clearTimeout( $( this ).data( 'timer' ) );
			} );
			$more_sharing_buttons.data( 'timer', false );

			// slide down forcibly
			$( '.sharedaddy .inner' ).slideUp();
		} );

		// Add click functionality
		$( '.sharedaddy ul' ).each( function () {
			if ( 'yep' === $( this ).data( 'has-click-events' ) ) {
				return;
			}
			$( this ).data( 'has-click-events', 'yep' );

			var printUrl = function ( uniqueId, urlToPrint ) {
				$( 'body:first' ).append(
					'<iframe style="position:fixed;top:100;left:100;height:1px;width:1px;border:none;" id="printFrame-' +
						uniqueId +
						'" name="printFrame-' +
						uniqueId +
						'" src="' +
						urlToPrint +
						'" onload="frames[\'printFrame-' +
						uniqueId +
						"'].focus();frames['printFrame-" +
						uniqueId +
						'\'].print();"></iframe>'
				);
			};

			// Print button
			$( this )
				.find( 'a.share-print' )
				.click( function () {
					var ref = $( this ).attr( 'href' ),
						do_print = function () {
							if ( ref.indexOf( '#print' ) === -1 ) {
								var uid = new Date().getTime();
								printUrl( uid, ref );
							} else {
								print();
							}
						};

					// Is the button in a dropdown?
					if ( $( this ).parents( '.sharing-hidden' ).length > 0 ) {
						$( this )
							.parents( '.inner' )
							.slideUp( 0, function () {
								do_print();
							} );
					} else {
						do_print();
					}

					return false;
				} );

			// Press This button
			$( this )
				.find( 'a.share-press-this' )
				.click( function () {
					var s = '';

					if ( window.getSelection ) {
						s = window.getSelection();
					} else if ( document.getSelection ) {
						s = document.getSelection();
					} else if ( document.selection ) {
						s = document.selection.createRange().text;
					}

					if ( s ) {
						$( this ).attr( 'href', $( this ).attr( 'href' ) + '&sel=' + encodeURI( s ) );
					}

					if (
						! window.open(
							$( this ).attr( 'href' ),
							't',
							'toolbar=0,resizable=1,scrollbars=1,status=1,width=720,height=570'
						)
					) {
						document.location.href = $( this ).attr( 'href' );
					}

					return false;
				} );

			// Email button
			$( 'a.share-email', this ).on( 'click', function () {
				var url = $( this ).attr( 'href' );
				var currentDomain = window.location.protocol + '//' + window.location.hostname + '/';
				if ( url.indexOf( currentDomain ) !== 0 ) {
					return true;
				}

				if ( $sharing_email.is( ':visible' ) ) {
					$sharing_email.slideUp( 200 );
				} else {
					$( '.sharedaddy .inner' ).slideUp();

					$( '#sharing_email .response' ).remove();
					$( '#sharing_email form' ).show();
					$( '#sharing_email form input[type=submit]' ).removeAttr( 'disabled' );
					$( '#sharing_email form a.sharing_cancel' ).show();

					// Reset reCATPCHA if exists.
					if (
						'object' === typeof grecaptcha &&
						'function' === typeof grecaptcha.reset &&
						window.___grecaptcha_cfg.count
					) {
						grecaptcha.reset();
					}

					// Show dialog
					$sharing_email
						.css( {
							left: $( this ).offset().left + 'px',
							top: $( this ).offset().top + $( this ).height() + 'px',
						} )
						.slideDown( 200 );

					// Hook up other buttons
					$( '#sharing_email a.sharing_cancel' )
						.unbind( 'click' )
						.click( function () {
							$( '#sharing_email .errors' ).hide();
							$sharing_email.slideUp( 200 );
							$( '#sharing_background' ).fadeOut();
							return false;
						} );

					// Submit validation
					$( '#sharing_email input[type=submit]' )
						.unbind( 'click' )
						.click( function () {
							var form = $( this ).parents( 'form' );
							var source_email_input = form.find( 'input[name=source_email]' );
							var target_email_input = form.find( 'input[name=target_email]' );

							// Disable buttons + enable loading icon
							$( this ).prop( 'disabled', true );
							form.find( 'a.sharing_cancel' ).hide();
							form.find( 'img.loading' ).show();

							$( '#sharing_email .errors' ).hide();
							$( '#sharing_email .error' ).removeClass( 'error' );

							if ( ! source_email_input.share_is_email() ) {
								source_email_input.addClass( 'error' );
							}

							if ( ! target_email_input.share_is_email() ) {
								target_email_input.addClass( 'error' );
							}

							if ( $( '#sharing_email .error' ).length === 0 ) {
								// AJAX send the form
								$.ajax( {
									url: url,
									type: 'POST',
									data: form.serialize(),
									success: function ( response ) {
										form.find( 'img.loading' ).hide();

										if ( response === '1' || response === '2' || response === '3' ) {
											$( '#sharing_email .errors-' + response ).show();
											form.find( 'input[type=submit]' ).removeAttr( 'disabled' );
											form.find( 'a.sharing_cancel' ).show();

											if (
												'object' === typeof grecaptcha &&
												'function' === typeof grecaptcha.reset
											) {
												grecaptcha.reset();
											}
										} else {
											$( '#sharing_email form' ).hide();
											$sharing_email.append( response );
											$( '#sharing_email a.sharing_cancel' ).click( function () {
												$sharing_email.slideUp( 200 );
												$( '#sharing_background' ).fadeOut();
												return false;
											} );
										}
									},
								} );

								return false;
							}

							form.find( 'img.loading' ).hide();
							form.find( 'input[type=submit]' ).removeAttr( 'disabled' );
							form.find( 'a.sharing_cancel' ).show();
							$( '#sharing_email .errors-1' ).show();

							return false;
						} );
				}

				return false;
			} );
		} );

		$( 'li.share-email, li.share-custom a.sharing-anchor' ).addClass( 'share-service-visible' );
	}
} )( jQuery );
